#pragma once

#include <mapreduce/yt/interface/client.h>
#include <vector>

namespace maps::wiki::yt_stubs {

class NodeWriterImplStub : public NYT::INodeWriterImpl
{
public:
    void AddRow(const NYT::TNode& row, size_t tableIndex = 0) override;
    void AddRow(NYT::TNode&& row, size_t tableIndex = 0) override;
    size_t GetTableCount() const override;
    void FinishTable(size_t) override;

public:
    NodeWriterImplStub();
    const std::vector<NYT::TNode>& getOutputRows() const;

private:
    std::vector<NYT::TNode> rows_;
};

// Factory
//
TIntrusivePtr<NYT::TTableWriter<NYT::TNode>>
createTableWriterStub(TIntrusivePtr<NodeWriterImplStub> writerImpl);

} // namespace maps::wiki::yt_stubs
