#!/bin/bash

#DBNAME=mapspro_$USER
DBNAME=$1
if [ -z "$DBNAME" ]; then
    echo "Empty dbname"
    exit 1
fi
echo $DBNAME

HOST="c-mdb4scmh2qhed40lergn.rw.db.yandex.net"
PORT=6432
USERNAME="mapspro"
DUMP="dump"

echo "Create dump from dataprod-db"
pg_dump -h dataprod-db.vla.yp-c.yandex.net -p 5432 --username $USERNAME -d $DBNAME \
    -Fd -j8 -f $DUMP

echo "Restore dump to MDB: $HOST"
pg_restore --host $HOST -d $DBNAME --port $PORT --username $USERNAME \
    -Fd -j8 $DUMP

echo "Remove $DUMP directory"
rm -rf $DUMP
