#!/bin/bash

#DBNAME=mapspro_$USER
DBNAME=$1
if [ -z "$DBNAME" ]; then
    echo "Empty dbname"
    exit 1
fi
echo $DBNAME

HOST="c-mdb4scmh2qhed40lergn.rw.db.yandex.net"
PORT=6432
USERNAME="mapspro"
DUMP="dump_acl"

# core (production)
HOST_SRC="c-mdbg3hms1oasjh7jtiki.rw.db.yandex.net"
DBNAME_SRC="mapspro"

# dataprod_development
#HOST_SRC="$HOST"
#DBNAME_SRC="mapspro_template"

echo "Create dump (schema acl) from MDB: $HOST_SRC / $DBNAME_SRC"
pg_dump -h $HOST_SRC -p $PORT --username $USERNAME -d $DBNAME_SRC \
    -Fd -j8 -f $DUMP \
    --schema=acl

echo "Remove old acl schema"
psql postgresql://$USERNAME@$HOST:$PORT/$DBNAME -c "DROP SCHEMA acl CASCADE";

echo "Restore dump to MDB: $HOST"
pg_restore --host $HOST -d $DBNAME --port $PORT --username $USERNAME \
    -Fd -j8 $DUMP

echo "Remove $DUMP directory"
rm -rf $DUMP
