#!/bin/bash

#DBNAME=mapspro_$USER
DBNAME=$1
if [ -z "$DBNAME" ]; then
    echo "Empty dbname"
    exit 1
fi
echo $DBNAME

echo "Build pgmigrate_helper"
ya make ../pgmigrate_helper/ya.make

LATEST=`ls -1 ../migrations/V*__*.sql |tail -1 |cut -f1 -d_ |cut -f2 -dV`
echo "Latest version from directory: $LATEST"

TOOL="../pgmigrate_helper/pgmigrate_helper"
CONFIG="../config.development.yaml"
MIDDLE_VERSION=334

echo "Upgrade 1 .. $MIDDLE_VERSION"
$TOOL -c $CONFIG -e $DBNAME migrate -t $MIDDLE_VERSION -d ../
for i in `seq $[$MIDDLE_VERSION+1] $LATEST`
do
    echo "Upgrade $i"
    $TOOL -c $CONFIG -e $DBNAME migrate -t $i -d ../
done
echo "Done"
