SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

CREATE SEQUENCE public.token_seq;


DROP FUNCTION IF EXISTS public.get_token();

CREATE OR REPLACE FUNCTION public.get_token()
    RETURNS text AS
$BODY$
DECLARE
    tok bigint;
    ts bigint := floor(EXTRACT(EPOCH FROM NOW()));
BEGIN
    INSERT INTO public.tokens DEFAULT VALUES RETURNING id INTO tok;
    IF mod(tok, 10000) = 0 THEN -- 10k period
        DELETE FROM public.tokens WHERE id < (tok - 100000); -- 100k for history
    END IF;
    RETURN ts||':'||tok;
END;
$BODY$
LANGUAGE plpgsql;




DROP FUNCTION IF EXISTS public.check_token(token bigint);
DROP FUNCTION IF EXISTS public.check_token(token bigint, tab int);
DROP FUNCTION IF EXISTS public.check_token(token character varying);

CREATE OR REPLACE FUNCTION public.check_token(token text)
    RETURNS boolean AS
$BODY$
DECLARE
    tok text := split_part(token, ':', 2);
    ts bigint;
BEGIN
    IF (tok='') THEN
        RETURN FALSE;
    END IF;
    ts := (split_part(token, ':', 1))::bigint;
    IF EXTRACT(EPOCH FROM NOW()) > ts + 3600 THEN -- 1 hours
        RETURN TRUE;
    END IF;
    PERFORM 1 FROM public.tokens WHERE id = tok::bigint;
    RETURN FOUND;
END;
$BODY$
LANGUAGE plpgsql;



CREATE TABLE tokens(id bigint not null default nextval('token_seq'::regclass));

DROP SCHEMA IF EXISTS social CASCADE;
CREATE SCHEMA social;


CREATE TABLE social.user(
    uid bigint NOT NULL PRIMARY KEY,
    login varchar NOT NULL DEFAULT '',
    name varchar NOT NULL DEFAULT '',
    registration_date timestamp with time zone default NOW()
);

CREATE TABLE social.role(
    id serial PRIMARY KEY,
    name varchar(255) NOT NULL,
    can_read_data boolean,
    can_modify_data boolean,
    can_read_permissions boolean,
    can_modify_permissions boolean
);


INSERT INTO social.role (name, can_read_data, can_modify_data,
    can_read_permissions, can_modify_permissions) VALUES
    ('manager', true, true, true, true),
    ('editor', true, true, false, false),
    ('viewer', true, false, false, false);

CREATE TABLE social.user_role(
    uid bigint REFERENCES social.user(uid) ON DELETE CASCADE,
    role_id bigint REFERENCES social.role(id) ON DELETE CASCADE,
    CONSTRAINT user_roles_pkey PRIMARY KEY(uid, role_id));


CREATE TYPE social.feed_type AS ENUM ('user', 'aoi');
CREATE TYPE social.branch_type AS ENUM ('trunk', 'stable');

CREATE TABLE social.msg (
    id serial PRIMARY KEY,
    feed social.feed_type NOT NULL,
    branch social.branch_type NOT NULL,
    subscriber bigint NOT NULL,
    uid bigint NOT NULL,
    action text NOT NULL,
    date timestamp with time zone NOT NULL,
    data text
);


CREATE INDEX msg_date_idx ON social.msg USING BTREE(feed, subscriber, date);
CREATE INDEX msg_action_idx ON social.msg USING BTREE(feed, subscriber, action, date);

CREATE SCHEMA vrevisions_trunk;




SET search_path = vrevisions_trunk, pg_catalog;


CREATE FUNCTION objects_a_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF ( NEW.zmin >= 16) THEN
        INSERT INTO objects_a16 VALUES (NEW.*);    
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_a14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_a12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_a10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_a8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7) THEN
        INSERT INTO objects_a7 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range.  Fix the objects_a_insert_trigger() function!';
    END IF;        
    RETURN NULL;
END;
$$;





CREATE FUNCTION objects_l_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF ( NEW.zmin >= 15) THEN
        INSERT INTO objects_l15 VALUES (NEW.*);    
    ELSIF ( NEW.zmin >=12 and NEW.zmin < 15) THEN
        INSERT INTO objects_l12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >=10 and NEW.zmin < 12) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);    
    ELSIF ( NEW.zmin <= 9) THEN
        INSERT INTO objects_l9 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range.  Fix the objects_l_insert_trigger() function!';    
    END IF;        
    RETURN NULL;
END;
$$;





CREATE FUNCTION objects_l15_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 15) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_l15 where id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$$;






CREATE FUNCTION objects_l12_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 15) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_l12 where id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$$;






CREATE FUNCTION objects_l10_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 10 and NEW.zmin < 12) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_l10 where id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$$;






CREATE FUNCTION objects_l9_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin <= 9) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_l9 where id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$$;





CREATE FUNCTION objects_a16_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 16) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a16 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;




CREATE FUNCTION objects_a14_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 14 AND NEW.zmin < 16) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a14 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;




CREATE FUNCTION objects_a12_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 14) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a12 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;





CREATE FUNCTION objects_a10_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 10 AND NEW.zmin < 12) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a10 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;




CREATE FUNCTION objects_a8_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin >= 8 AND NEW.zmin < 10) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a8 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;





CREATE FUNCTION objects_a7_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.zmin <= 7) THEN
        RETURN NEW;
    END IF;
    DELETE from objects_a7 where id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$$;





CREATE FUNCTION statistics_increment(attr character varying, val character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
    UPDATE statistics SET count = count + 1 WHERE attribute=attr AND value=val;
    IF found THEN
      RETURN;
    END IF;
    INSERT INTO statistics(attribute, value, count) VALUES (attr, val, 1);
END$$;





CREATE FUNCTION statistics_increment_exception(category character varying, attr character varying, val character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
BEGIN    
    INSERT INTO statistics(category_id, attribute, value, count) VALUES (category, attr, val, 1);
    EXCEPTION WHEN unique_violation THEN
      UPDATE statistics SET count = count + 1 WHERE category_id=category AND attribute=attr AND value=val;
    END;
END$$;




SET default_tablespace = '';

SET default_with_oids = false;


CREATE TABLE labels (
    id bigint NOT NULL,
    containerid bigint,
    bbox public.geometry,
    labeldata bytea,
    objectid bigint,
    labeltext text,
    created timestamp with time zone DEFAULT now()
);





CREATE SEQUENCE labels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;





ALTER SEQUENCE labels_id_seq OWNED BY labels.id;



CREATE TABLE labels0 (
)
INHERITS (labels);





CREATE TABLE labels1 (
)
INHERITS (labels);





CREATE TABLE labels10 (
)
INHERITS (labels);





CREATE TABLE labels11 (
)
INHERITS (labels);





CREATE TABLE labels12 (
)
INHERITS (labels);





CREATE TABLE labels13 (
)
INHERITS (labels);





CREATE TABLE labels14 (
)
INHERITS (labels);





CREATE TABLE labels15 (
)
INHERITS (labels);





CREATE TABLE labels16 (
)
INHERITS (labels);





CREATE TABLE labels17 (
)
INHERITS (labels);





CREATE TABLE labels18 (
)
INHERITS (labels);





CREATE TABLE labels19 (
)
INHERITS (labels);





CREATE TABLE labels2 (
)
INHERITS (labels);





CREATE TABLE labels20 (
)
INHERITS (labels);





CREATE TABLE labels21 (
)
INHERITS (labels);





CREATE TABLE labels22 (
)
INHERITS (labels);





CREATE TABLE labels3 (
)
INHERITS (labels);





CREATE TABLE labels4 (
)
INHERITS (labels);





CREATE TABLE labels5 (
)
INHERITS (labels);





CREATE TABLE labels6 (
)
INHERITS (labels);





CREATE TABLE labels7 (
)
INHERITS (labels);





CREATE TABLE labels8 (
)
INHERITS (labels);





CREATE TABLE labels9 (
)
INHERITS (labels);





CREATE TABLE objects (
    id bigint NOT NULL,
    commit_id bigint NOT NULL,
    the_geom public.geometry,
    zmin integer DEFAULT 0 NOT NULL,
    zmax integer,
    modified timestamp with time zone,
    domain_attrs public.hstore,
    service_attrs public.hstore,
    CONSTRAINT objects_commit_id_check CHECK ((commit_id > 0))
);





CREATE TABLE objects_a (
    area double precision NOT NULL,
    the_center public.geometry,
    icon_zmin integer DEFAULT 0
)
INHERITS (objects);





CREATE TABLE objects_a10 (
    CONSTRAINT objects_a10_zmin_check CHECK (((zmin >= 10) AND (zmin < 12)))
)
INHERITS (objects_a);





CREATE TABLE objects_a12 (
    CONSTRAINT objects_a12_zmin_check CHECK (((zmin >= 12) AND (zmin < 14)))
)
INHERITS (objects_a);





CREATE TABLE objects_a14 (
    CONSTRAINT objects_a14_zmin_check CHECK (((zmin >= 14) AND (zmin < 16)))
)
INHERITS (objects_a);





CREATE TABLE objects_a16 (
    CONSTRAINT objects_a16_zmin_check CHECK ((zmin >= 16))
)
INHERITS (objects_a);





CREATE TABLE objects_a7 (
    CONSTRAINT objects_a7_zmin_check CHECK ((zmin <= 7))
)
INHERITS (objects_a);





CREATE TABLE objects_a8 (
    CONSTRAINT objects_a8_zmin_check CHECK (((zmin >= 8) AND (zmin < 10)))
)
INHERITS (objects_a);





CREATE TABLE objects_c (
)
INHERITS (objects);





CREATE TABLE objects_l (
    length double precision DEFAULT 0 NOT NULL
)
INHERITS (objects);





CREATE TABLE objects_l10 (
    CONSTRAINT objects_l10_zmin_check CHECK (((zmin >= 10) AND (zmin < 12)))
)
INHERITS (objects_l);





CREATE TABLE objects_l12 (
    CONSTRAINT objects_l12_zmin_check CHECK (((zmin >= 12) AND (zmin < 15)))
)
INHERITS (objects_l);





CREATE TABLE objects_l15 (
    CONSTRAINT objects_l15_zmin_check CHECK ((zmin >= 15))
)
INHERITS (objects_l);





CREATE TABLE objects_l9 (
    CONSTRAINT objects_l9_zmin_check CHECK ((zmin <= 9))
)
INHERITS (objects_l);





CREATE TABLE objects_p (
)
INHERITS (objects);





CREATE TABLE objects_r (
    master_id bigint NOT NULL,
    slave_id bigint NOT NULL
)
INHERITS (objects);





CREATE TABLE statistics (
    attribute text NOT NULL,
    value text NOT NULL,
    count integer DEFAULT 0 NOT NULL,
    category_id text
);





ALTER TABLE labels ALTER COLUMN id SET DEFAULT nextval('labels_id_seq'::regclass);



ALTER TABLE ONLY labels0
    ADD CONSTRAINT labels0_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels10
    ADD CONSTRAINT labels10_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels11
    ADD CONSTRAINT labels11_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels12
    ADD CONSTRAINT labels12_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels13
    ADD CONSTRAINT labels13_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels14
    ADD CONSTRAINT labels14_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels15
    ADD CONSTRAINT labels15_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels16
    ADD CONSTRAINT labels16_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels17
    ADD CONSTRAINT labels17_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels18
    ADD CONSTRAINT labels18_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels19
    ADD CONSTRAINT labels19_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels1
    ADD CONSTRAINT labels1_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels20
    ADD CONSTRAINT labels20_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels21
    ADD CONSTRAINT labels21_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels22
    ADD CONSTRAINT labels22_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels2
    ADD CONSTRAINT labels2_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels3
    ADD CONSTRAINT labels3_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels4
    ADD CONSTRAINT labels4_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels5
    ADD CONSTRAINT labels5_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels6
    ADD CONSTRAINT labels6_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels7
    ADD CONSTRAINT labels7_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels8
    ADD CONSTRAINT labels8_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels9
    ADD CONSTRAINT labels9_pkey PRIMARY KEY (id);



ALTER TABLE ONLY labels
    ADD CONSTRAINT labels_id_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a10
    ADD CONSTRAINT objects_a10_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a12
    ADD CONSTRAINT objects_a12_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a14
    ADD CONSTRAINT objects_a14_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a16
    ADD CONSTRAINT objects_a16_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a7
    ADD CONSTRAINT objects_a7_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a8
    ADD CONSTRAINT objects_a8_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_a
    ADD CONSTRAINT objects_a_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_c
    ADD CONSTRAINT objects_c_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_l10
    ADD CONSTRAINT objects_l10_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_l12
    ADD CONSTRAINT objects_l12_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_l15
    ADD CONSTRAINT objects_l15_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_l9
    ADD CONSTRAINT objects_l9_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_l
    ADD CONSTRAINT objects_l_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects_p
    ADD CONSTRAINT objects_p_pkey PRIMARY KEY (id);



ALTER TABLE ONLY objects
    ADD CONSTRAINT objects_pkey PRIMARY KEY (id);



ALTER TABLE ONLY statistics
    ADD CONSTRAINT statistics_pkey PRIMARY KEY (attribute, value);

CREATE INDEX labels0_bbox_index ON labels0 USING gist (bbox);
CREATE INDEX labels0_containerid_index ON labels0 USING btree (containerid);
CREATE INDEX labels0_objectid_index ON labels0 USING btree (objectid);
CREATE INDEX labels10_bbox_index ON labels10 USING gist (bbox);
CREATE INDEX labels10_containerid_index ON labels10 USING btree (containerid);
CREATE INDEX labels10_objectid_index ON labels10 USING btree (objectid);
CREATE INDEX labels11_bbox_index ON labels11 USING gist (bbox);
CREATE INDEX labels11_containerid_index ON labels11 USING btree (containerid);
CREATE INDEX labels11_objectid_index ON labels11 USING btree (objectid);
CREATE INDEX labels12_bbox_index ON labels12 USING gist (bbox);
CREATE INDEX labels12_containerid_index ON labels12 USING btree (containerid);
CREATE INDEX labels12_objectid_index ON labels12 USING btree (objectid);
CREATE INDEX labels13_bbox_index ON labels13 USING gist (bbox);
CREATE INDEX labels13_containerid_index ON labels13 USING btree (containerid);
CREATE INDEX labels13_objectid_index ON labels13 USING btree (objectid);
CREATE INDEX labels14_bbox_index ON labels14 USING gist (bbox);
CREATE INDEX labels14_containerid_index ON labels14 USING btree (containerid);
CREATE INDEX labels14_objectid_index ON labels14 USING btree (objectid);



CREATE INDEX labels15_bbox_index ON labels15 USING gist (bbox);



CREATE INDEX labels15_containerid_index ON labels15 USING btree (containerid);



CREATE INDEX labels15_objectid_index ON labels15 USING btree (objectid);



CREATE INDEX labels16_bbox_index ON labels16 USING gist (bbox);



CREATE INDEX labels16_containerid_index ON labels16 USING btree (containerid);



CREATE INDEX labels16_objectid_index ON labels16 USING btree (objectid);



CREATE INDEX labels17_bbox_index ON labels17 USING gist (bbox);



CREATE INDEX labels17_containerid_index ON labels17 USING btree (containerid);



CREATE INDEX labels17_objectid_index ON labels17 USING btree (objectid);



CREATE INDEX labels18_bbox_index ON labels18 USING gist (bbox);



CREATE INDEX labels18_containerid_index ON labels18 USING btree (containerid);



CREATE INDEX labels18_objectid_index ON labels18 USING btree (objectid);



CREATE INDEX labels19_bbox_index ON labels19 USING gist (bbox);



CREATE INDEX labels19_containerid_index ON labels19 USING btree (containerid);



CREATE INDEX labels19_objectid_index ON labels19 USING btree (objectid);



CREATE INDEX labels1_bbox_index ON labels1 USING gist (bbox);



CREATE INDEX labels1_containerid_index ON labels1 USING btree (containerid);



CREATE INDEX labels1_objectid_index ON labels1 USING btree (objectid);



CREATE INDEX labels20_bbox_index ON labels20 USING gist (bbox);



CREATE INDEX labels20_containerid_index ON labels20 USING btree (containerid);



CREATE INDEX labels20_objectid_index ON labels20 USING btree (objectid);



CREATE INDEX labels21_bbox_index ON labels21 USING gist (bbox);



CREATE INDEX labels21_containerid_index ON labels21 USING btree (containerid);



CREATE INDEX labels21_objectid_index ON labels21 USING btree (objectid);



CREATE INDEX labels22_bbox_index ON labels22 USING gist (bbox);



CREATE INDEX labels22_containerid_index ON labels22 USING btree (containerid);



CREATE INDEX labels22_objectid_index ON labels22 USING btree (objectid);



CREATE INDEX labels2_bbox_index ON labels2 USING gist (bbox);



CREATE INDEX labels2_containerid_index ON labels2 USING btree (containerid);



CREATE INDEX labels2_objectid_index ON labels2 USING btree (objectid);



CREATE INDEX labels3_bbox_index ON labels3 USING gist (bbox);



CREATE INDEX labels3_containerid_index ON labels3 USING btree (containerid);



CREATE INDEX labels3_objectid_index ON labels3 USING btree (objectid);



CREATE INDEX labels4_bbox_index ON labels4 USING gist (bbox);



CREATE INDEX labels4_containerid_index ON labels4 USING btree (containerid);



CREATE INDEX labels4_objectid_index ON labels4 USING btree (objectid);



CREATE INDEX labels5_bbox_index ON labels5 USING gist (bbox);



CREATE INDEX labels5_containerid_index ON labels5 USING btree (containerid);



CREATE INDEX labels5_objectid_index ON labels5 USING btree (objectid);



CREATE INDEX labels6_bbox_index ON labels6 USING gist (bbox);



CREATE INDEX labels6_containerid_index ON labels6 USING btree (containerid);



CREATE INDEX labels6_objectid_index ON labels6 USING btree (objectid);



CREATE INDEX labels7_bbox_index ON labels7 USING gist (bbox);



CREATE INDEX labels7_containerid_index ON labels7 USING btree (containerid);



CREATE INDEX labels7_objectid_index ON labels7 USING btree (objectid);



CREATE INDEX labels8_bbox_index ON labels8 USING gist (bbox);



CREATE INDEX labels8_containerid_index ON labels8 USING btree (containerid);



CREATE INDEX labels8_objectid_index ON labels8 USING btree (objectid);



CREATE INDEX labels9_bbox_index ON labels9 USING gist (bbox);



CREATE INDEX labels9_containerid_index ON labels9 USING btree (containerid);



CREATE INDEX labels9_objectid_index ON labels9 USING btree (objectid);



CREATE INDEX objects_a10_area_index ON objects_a10 USING btree (area);



CREATE INDEX objects_a10_domain_attrs_gist ON objects_a10 USING gist (domain_attrs);
CREATE INDEX objects_a10_service_attrs_gist ON objects_a10 USING gist (service_attrs);


CREATE INDEX objects_a10_commit_id_index ON objects_a10 USING btree (commit_id);



CREATE INDEX objects_a10_the_center_index ON objects_a10 USING gist (the_center);



CREATE INDEX objects_a10_the_geom_index ON objects_a10 USING gist (the_geom);



CREATE INDEX objects_a10_zmax_index ON objects_a10 USING btree (zmax);



CREATE INDEX objects_a10_zmin_index ON objects_a10 USING btree (zmin);



CREATE INDEX objects_a12_area_index ON objects_a12 USING btree (area);



CREATE INDEX objects_a12_domain_attrs_gist ON objects_a12 USING gist (domain_attrs);
CREATE INDEX objects_a12_service_attrs_gist ON objects_a12 USING gist (service_attrs);


CREATE INDEX objects_a12_commit_id_index ON objects_a12 USING btree (commit_id);



CREATE INDEX objects_a12_the_center_index ON objects_a12 USING gist (the_center);



CREATE INDEX objects_a12_the_geom_index ON objects_a12 USING gist (the_geom);



CREATE INDEX objects_a12_zmax_index ON objects_a12 USING btree (zmax);



CREATE INDEX objects_a12_zmin_index ON objects_a12 USING btree (zmin);



CREATE INDEX objects_a14_area_index ON objects_a14 USING btree (area);



CREATE INDEX objects_a14_domain_attrs_gist ON objects_a14 USING gist (domain_attrs);
CREATE INDEX objects_a14_service_attrs_gist ON objects_a14 USING gist (service_attrs);


CREATE INDEX objects_a14_commit_id_index ON objects_a14 USING btree (commit_id);



CREATE INDEX objects_a14_the_center_index ON objects_a14 USING gist (the_center);



CREATE INDEX objects_a14_the_geom_index ON objects_a14 USING gist (the_geom);



CREATE INDEX objects_a14_zmax_index ON objects_a14 USING btree (zmax);



CREATE INDEX objects_a14_zmin_index ON objects_a14 USING btree (zmin);



CREATE INDEX objects_a16_area_index ON objects_a16 USING btree (area);



CREATE INDEX objects_a16_domain_attrs_gist ON objects_a16 USING gist (domain_attrs);
CREATE INDEX objects_a16_service_attrs_gist ON objects_a16 USING gist (service_attrs);


CREATE INDEX objects_a16_commit_id_index ON objects_a16 USING btree (commit_id);



CREATE INDEX objects_a16_the_center_index ON objects_a16 USING gist (the_center);



CREATE INDEX objects_a16_the_geom_index ON objects_a16 USING gist (the_geom);



CREATE INDEX objects_a16_zmax_index ON objects_a16 USING btree (zmax);



CREATE INDEX objects_a16_zmin_index ON objects_a16 USING btree (zmin);



CREATE INDEX objects_a7_area_index ON objects_a7 USING btree (area);



CREATE INDEX objects_a7_domain_attrs_gist ON objects_a7 USING gist (domain_attrs);
CREATE INDEX objects_a7_service_attrs_gist ON objects_a7 USING gist (service_attrs);


CREATE INDEX objects_a7_commit_id_index ON objects_a7 USING btree (commit_id);



CREATE INDEX objects_a7_the_center_index ON objects_a7 USING gist (the_center);



CREATE INDEX objects_a7_the_geom_index ON objects_a7 USING gist (the_geom);



CREATE INDEX objects_a7_zmax_index ON objects_a7 USING btree (zmax);



CREATE INDEX objects_a7_zmin_index ON objects_a7 USING btree (zmin);



CREATE INDEX objects_a8_area_index ON objects_a8 USING btree (area);



CREATE INDEX objects_a8_domain_attrs_gist ON objects_a8 USING gist (domain_attrs);
CREATE INDEX objects_a8_service_attrs_gist ON objects_a8 USING gist (service_attrs);


CREATE INDEX objects_a8_commit_id_index ON objects_a8 USING btree (commit_id);



CREATE INDEX objects_a8_the_center_index ON objects_a8 USING gist (the_center);



CREATE INDEX objects_a8_the_geom_index ON objects_a8 USING gist (the_geom);



CREATE INDEX objects_a8_zmax_index ON objects_a8 USING btree (zmax);



CREATE INDEX objects_a8_zmin_index ON objects_a8 USING btree (zmin);



CREATE INDEX objects_a_area_index ON objects_a USING btree (area);



CREATE INDEX objects_a_domain_attrs_gist ON objects_a USING gist (domain_attrs);
CREATE INDEX objects_a_service_attrs_gist ON objects_a USING gist (service_attrs);


CREATE INDEX objects_a_commit_id_index ON objects_a USING btree (commit_id);



CREATE INDEX objects_a_icon_zmin_index ON objects_a USING btree (icon_zmin);



CREATE INDEX objects_a_the_center_index ON objects_a USING gist (the_center);



CREATE INDEX objects_a_the_geom_index ON objects_a USING gist (the_geom);



CREATE INDEX objects_a_zmax_index ON objects_a USING btree (zmax);



CREATE INDEX objects_a_zmin_index ON objects_a USING btree (zmin);



CREATE INDEX objects_domain_attrs_gist ON objects USING gist (domain_attrs);
CREATE INDEX objects_service_attrs_gist ON objects USING gist (service_attrs);


CREATE INDEX objects_c_domain_attrs_gist ON objects_c USING gist (domain_attrs);
CREATE INDEX objects_c_service_attrs_gist ON objects_c USING gist (service_attrs);


CREATE INDEX objects_c_commit_id_index ON objects_c USING btree (commit_id);



CREATE INDEX objects_c_the_geom_index ON objects_c USING gist (the_geom);



CREATE INDEX objects_c_zmax_index ON objects_c USING btree (zmax);



CREATE INDEX objects_c_zmin_index ON objects_c USING btree (zmin);



CREATE INDEX objects_commit_id_index ON objects USING btree (commit_id);



CREATE INDEX objects_l10_domain_attrs_gist ON objects_l10 USING gist (domain_attrs);
CREATE INDEX objects_l10_service_attrs_gist ON objects_l10 USING gist (service_attrs);


CREATE INDEX objects_l10_commit_id_index ON objects_l10 USING btree (commit_id);

CREATE INDEX objects_l10_length_index ON objects_l10 USING btree (length);


CREATE INDEX objects_l10_the_geom_index ON objects_l10 USING gist (the_geom);



CREATE INDEX objects_l10_zmax_index ON objects_l10 USING btree (zmax);



CREATE INDEX objects_l10_zmin_index ON objects_l10 USING btree (zmin);



CREATE INDEX objects_l12_domain_attrs_gist ON objects_l12 USING gist (domain_attrs);
CREATE INDEX objects_l12_service_attrs_gist ON objects_l12 USING gist (service_attrs);


CREATE INDEX objects_l12_commit_id_index ON objects_l12 USING btree (commit_id);


CREATE INDEX objects_l12_length_index ON objects_l12 USING btree (length);


CREATE INDEX objects_l12_the_geom_index ON objects_l12 USING gist (the_geom);



CREATE INDEX objects_l12_zmax_index ON objects_l12 USING btree (zmax);



CREATE INDEX objects_l12_zmin_index ON objects_l12 USING btree (zmin);



CREATE INDEX objects_l15_domain_attrs_gist ON objects_l15 USING gist (domain_attrs);
CREATE INDEX objects_l15_service_attrs_gist ON objects_l15 USING gist (service_attrs);


CREATE INDEX objects_l15_commit_id_index ON objects_l15 USING btree (commit_id);


CREATE INDEX objects_l15_length_index ON objects_l15 USING btree (length);



CREATE INDEX objects_l15_the_geom_index ON objects_l15 USING gist (the_geom);



CREATE INDEX objects_l15_zmax_index ON objects_l15 USING btree (zmax);



CREATE INDEX objects_l15_zmin_index ON objects_l15 USING btree (zmin);



CREATE INDEX objects_l9_domain_attrs_gist ON objects_l9 USING gist (domain_attrs);
CREATE INDEX objects_l9_service_attrs_gist ON objects_l9 USING gist (service_attrs);


CREATE INDEX objects_l9_commit_id_index ON objects_l9 USING btree (commit_id);



CREATE INDEX objects_l9_length_index ON objects_l9 USING btree (length);



CREATE INDEX objects_l9_the_geom_index ON objects_l9 USING gist (the_geom);



CREATE INDEX objects_l9_zmax_index ON objects_l9 USING btree (zmax);



CREATE INDEX objects_l9_zmin_index ON objects_l9 USING btree (zmin);



CREATE INDEX objects_l_domain_attrs_gist ON objects_l USING gist (domain_attrs);
CREATE INDEX objects_l_service_attrs_gist ON objects_l USING gist (service_attrs);


CREATE INDEX objects_l_commit_id_index ON objects_l USING btree (commit_id);


CREATE INDEX objects_l_length_index ON objects_l USING btree (length);


CREATE INDEX objects_l_the_geom_index ON objects_l USING gist (the_geom);



CREATE INDEX objects_l_zmax_index ON objects_l USING btree (zmax);



CREATE INDEX objects_l_zmin_index ON objects_l USING btree (zmin);



CREATE INDEX objects_links_pair_index ON objects_r USING btree (master_id, slave_id);



CREATE INDEX objects_modified_index ON objects USING btree (modified);



CREATE INDEX objects_p_domain_attrs_gist ON objects_p USING gist (domain_attrs);
CREATE INDEX objects_p_service_attrs_gist ON objects_p USING gist (service_attrs);


CREATE INDEX objects_p_commit_id_index ON objects_p USING btree (commit_id);



CREATE INDEX objects_p_the_geom_index ON objects_p USING gist (the_geom);



CREATE INDEX objects_p_zmax_index ON objects_p USING btree (zmax);



CREATE INDEX objects_p_zmin_index ON objects_p USING btree (zmin);



CREATE INDEX objects_r_id_index ON objects_r USING btree (id);



CREATE INDEX objects_r_master_id_index ON objects_r USING btree (master_id);



CREATE INDEX objects_r_slave_id_index ON objects_r USING btree (slave_id);



CREATE INDEX objects_the_geom_index ON objects USING gist (the_geom);



CREATE INDEX objects_zmax_index ON objects USING btree (zmax);



CREATE INDEX objects_zmin_index ON objects USING btree (zmin);



CREATE INDEX statistics_attribute_category_id_idx ON statistics USING btree (attribute, category_id);



CREATE TRIGGER insert_objects_l_trigger BEFORE INSERT ON objects_l FOR EACH ROW EXECUTE PROCEDURE objects_l_insert_trigger();



CREATE TRIGGER insert_objects_trigger BEFORE INSERT ON objects_a FOR EACH ROW EXECUTE PROCEDURE objects_a_insert_trigger();



CREATE TRIGGER update_objects_a10_trigger BEFORE UPDATE ON objects_a10 FOR EACH ROW EXECUTE PROCEDURE objects_a10_update_trigger();



CREATE TRIGGER update_objects_a12_trigger BEFORE UPDATE ON objects_a12 FOR EACH ROW EXECUTE PROCEDURE objects_a12_update_trigger();



CREATE TRIGGER update_objects_a14_trigger BEFORE UPDATE ON objects_a14 FOR EACH ROW EXECUTE PROCEDURE objects_a14_update_trigger();



CREATE TRIGGER update_objects_a16_trigger BEFORE UPDATE ON objects_a16 FOR EACH ROW EXECUTE PROCEDURE objects_a16_update_trigger();



CREATE TRIGGER update_objects_a7_trigger BEFORE UPDATE ON objects_a7 FOR EACH ROW EXECUTE PROCEDURE objects_a7_update_trigger();



CREATE TRIGGER update_objects_a8_trigger BEFORE UPDATE ON objects_a8 FOR EACH ROW EXECUTE PROCEDURE objects_a8_update_trigger();



CREATE TRIGGER update_objects_l10_trigger BEFORE UPDATE ON objects_l10 FOR EACH ROW EXECUTE PROCEDURE objects_l10_update_trigger();



CREATE TRIGGER update_objects_l12_trigger BEFORE UPDATE ON objects_l12 FOR EACH ROW EXECUTE PROCEDURE objects_l12_update_trigger();



CREATE TRIGGER update_objects_l15_trigger BEFORE UPDATE ON objects_l15 FOR EACH ROW EXECUTE PROCEDURE objects_l15_update_trigger();



CREATE TRIGGER update_objects_l9_trigger BEFORE UPDATE ON objects_l9 FOR EACH ROW EXECUTE PROCEDURE objects_l9_update_trigger();


CREATE SCHEMA service;



SET search_path = service, pg_catalog;


CREATE TABLE task (
    id serial PRIMARY KEY,
    type text NOT NULL,
    progress float NOT NULL DEFAULT 0.,
    celery_task_id text,
    created timestamp with time zone DEFAULT NOW(),
    created_by bigint NOT NULL,
    modified timestamp with time zone,
    modified_by bigint NOT NULL,
    finished timestamp with time zone
);


CREATE TYPE branch_type AS ENUM ('trunk', 'stable');

CREATE TABLE validation_task (
    id bigint PRIMARY KEY,
    branch branch_type NOT NULL,
    checks text[],
    aoi_geom public.geometry,
    aoi_id bigint
);


CREATE INDEX validation_task_aoi_index on validation_task USING gist(aoi_geom);

CREATE TABLE validation_message (
    id serial PRIMARY KEY,
    task_id integer NOT NULL,
    check_id text NOT NULL,
    severity text NOT NULL,
    description_tag text NOT NULL,
    object_ids bigint[] NOT NULL,
    the_geom public.geometry
);



CREATE INDEX validation_message_task_id_index ON validation_message USING btree(task_id);
CREATE INDEX validation_message_the_geom_index ON validation_message USING gist(the_geom);


--
-- Name: taskutils_task_state; Type: TYPE; Schema: service; Owner: mapadmin
--

CREATE TYPE taskutils_task_state AS ENUM (
    'created',
    'started',
    'done',
    'failed',
    'canceled',
    'terminated'
);




SET default_tablespace = '';

SET default_with_oids = false;

CREATE TABLE taskutils_tasks (
    id bigint NOT NULL,
    service_name text DEFAULT ''::text,
    task_name text DEFAULT ''::text,
    expires timestamp without time zone NOT NULL,
    status taskutils_task_state DEFAULT 'created'::taskutils_task_state NOT NULL,
    created timestamp without time zone DEFAULT now(),
    created_by bigint DEFAULT 0 NOT NULL,
    finished timestamp without time zone,
    input_data text DEFAULT ''::text NOT NULL,
    result text DEFAULT ''::text NOT NULL,
    error_message text DEFAULT ''::text NOT NULL
);





CREATE SEQUENCE taskutils_tasks_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;




ALTER SEQUENCE taskutils_tasks_seq OWNED BY taskutils_tasks.id;

ALTER TABLE taskutils_tasks ALTER COLUMN id SET DEFAULT nextval('taskutils_tasks_seq'::regclass);

ALTER TABLE ONLY taskutils_tasks
    ADD CONSTRAINT taskutils_tasks_pkey PRIMARY KEY (id);


CREATE INDEX taskutils_tasks_created_by_uid ON taskutils_tasks USING btree (created_by);

CREATE INDEX taskutils_tasks_created_date ON taskutils_tasks USING btree (created);

CREATE INDEX taskutils_tasks_expires_date ON taskutils_tasks USING btree (expires);

CREATE INDEX taskutils_tasks_service_name ON taskutils_tasks USING btree (service_name);

CREATE INDEX taskutils_tasks_status_type ON taskutils_tasks USING btree (status);

CREATE INDEX taskutils_tasks_task_name ON taskutils_tasks USING btree (task_name);

CREATE SCHEMA revision;

SET search_path = revision;


CREATE SEQUENCE commit_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;




CREATE SEQUENCE description_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;




CREATE SEQUENCE geometry_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;




CREATE SEQUENCE attributes_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;




CREATE SEQUENCE object_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;




CREATE TYPE commit_state_type AS ENUM (
    'draft',
    'revoked',
    'approved'
);


CREATE TABLE attributes (
    id bigint NOT NULL DEFAULT nextval('attributes_id_seq'::regclass),
    contents public.hstore,

    CONSTRAINT attributes_pkey PRIMARY KEY(id)
);

ALTER SEQUENCE attributes_id_seq OWNED BY attributes.id;


CREATE TABLE description (
    id bigint NOT NULL DEFAULT nextval('description_id_seq'::regclass),
    contents text NOT NULL,

    CONSTRAINT description_pkey PRIMARY KEY(id)
);

ALTER SEQUENCE description_id_seq OWNED BY description.id;


CREATE TABLE geometry (
    id bigint NOT NULL DEFAULT nextval('geometry_id_seq'::regclass),
    contents public.geometry NOT NULL,

    CONSTRAINT geometry_pkey PRIMARY KEY(id),

    CONSTRAINT enforce_dims_value CHECK ((public.ST_CoordDim(contents) = 2)),
    CONSTRAINT enforce_srid_value CHECK ((public.ST_Srid(contents) = 3395))
);

ALTER SEQUENCE geometry_id_seq OWNED BY geometry.id;

CREATE INDEX geometry_contents_idx ON geometry USING gist (contents);


CREATE TABLE commit (
    id bigint NOT NULL DEFAULT nextval('commit_id_seq'::regclass),
    state commit_state_type NOT NULL DEFAULT 'draft',
    trunk boolean NOT NULL,
    stable boolean NOT NULL,
    created timestamp without time zone NOT NULL DEFAULT now(),
    created_by bigint NOT NULL,
    attributes public.hstore,

    CONSTRAINT commit_pkey PRIMARY KEY(id),
    CONSTRAINT valid_user CHECK (created_by > 0),
    CONSTRAINT trunk_or_stable CHECK (trunk OR stable)
);

ALTER SEQUENCE commit_id_seq OWNED BY commit.id;

CREATE INDEX commit_state_idx ON commit USING btree (state);


CREATE TABLE object_revision (
    object_id bigint NOT NULL,
    commit_id bigint NOT NULL,
    prev_commit_id bigint NOT NULL,
    next_commit_id bigint NOT NULL DEFAULT 0,
    next_stable_commit_id bigint NOT NULL DEFAULT 0,
    deleted boolean NOT NULL,
    has_next_approved boolean NOT NULL DEFAULT FALSE,
    geometry_id bigint NOT NULL,
    attributes_id bigint NOT NULL,
    description_id bigint NOT NULL,
    master_object_id bigint NOT NULL,
    slave_object_id bigint NOT NULL,

    CONSTRAINT object_revision_pkey PRIMARY KEY(object_id, commit_id)
);


CREATE UNIQUE INDEX object_revision_next_commit_object_ids_idx ON object_revision USING btree (next_commit_id, object_id) WHERE next_commit_id > 0;
CREATE UNIQUE INDEX object_revision_next_stable_commit_object_ids_idx ON object_revision USING btree (next_stable_commit_id, object_id) WHERE next_stable_commit_id > 0;
CREATE INDEX object_revision_commit_id_idx ON object_revision USING btree (commit_id);
CREATE INDEX object_revision_master_object_id_idx ON object_revision USING btree (master_object_id);
CREATE INDEX object_revision_slave_object_id_idx ON object_revision USING btree (slave_object_id);
CREATE INDEX object_revision_has_next_approved_idx ON object_revision USING btree (has_next_approved);

SET search_path = "$user",public;
