CREATE SCHEMA acl;
set search_path=acl, public;
CREATE TABLE agent
(
  id bigserial NOT NULL,
  CONSTRAINT agent_pkey PRIMARY KEY (id )
);



CREATE TABLE "group"
(
  name text NOT NULL,
  CONSTRAINT group_pkey PRIMARY KEY (id )
)
INHERITS (agent);
CREATE UNIQUE INDEX group_name_idx ON "group" (name);


CREATE TYPE user_status_type AS ENUM (
    'active',
    'banned',
    'deleted'
);

CREATE TABLE "user"
(
  uid bigint NOT NULL,
  login text NOT NULL,
  created timestamp with time zone DEFAULT now(),
  created_by bigint NOT NULL,
  modified timestamp with time zone DEFAULT now(),
  modified_by bigint NOT NULL,
  status user_status_type NOT NULL DEFAULT 'active'::acl.user_status_type,
  CONSTRAINT user_pkey PRIMARY KEY ( id )
)
INHERITS (agent);
CREATE UNIQUE INDEX  user_uid_idx ON "user" (uid);
CREATE UNIQUE INDEX  user_login_idx ON "user" (login);


CREATE TABLE group_user
(
  group_id bigint NOT NULL,
  "user_id" bigint NOT NULL,
  CONSTRAINT group_user_pkey PRIMARY KEY (group_id , "user_id" ),
  CONSTRAINT group_user_user_foreign_key FOREIGN KEY ("user_id") REFERENCES acl."user" (id)
   ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT group_user_group_foreign_key FOREIGN KEY (group_id) REFERENCES acl."group" (id)
   ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE INDEX fki_group_user_user_foreign_key ON group_user("user_id");
CREATE INDEX fki_group_user_group_foreign_key ON group_user(group_id);


CREATE TABLE permission
(
  id bigserial NOT NULL,
  name text NOT NULL,
  parent_id bigint,
  CONSTRAINT permission_pkey PRIMARY KEY (id )
);
CREATE INDEX  permission_parent_id_idx ON permission (parent_id);
CREATE UNIQUE INDEX  permission_parent_id_name_idx ON permission (parent_id, name);




CREATE TABLE role
(
  id bigserial NOT NULL,
  name text,
  CONSTRAINT role_name_uniq UNIQUE (name ),
  CONSTRAINT role_pkey PRIMARY KEY (id )
);



CREATE TABLE policy
(
  agent_id bigint,
  role_id bigint,
  attrs hstore
  -- Next lines were commented, since postgres foreign constrains are not working
  -- for inherited tables.
  --,
  --CONSTRAINT policy_agent_foreign_key FOREIGN KEY (agent_id) REFERENCES agent (id)
  --ON UPDATE NO ACTION ON DELETE CASCADE,
  --CONSTRAINT policy_role_foreign_key FOREIGN KEY (role_id) REFERENCES role (id)
  --ON UPDATE NO ACTION ON DELETE CASCADE
);
CREATE UNIQUE INDEX policy_agent_role_attrs_idx ON policy(agent_id, role_id, attrs);
CREATE INDEX fki_policy_agent_foreign_key ON policy(agent_id);
CREATE INDEX fki_policy_role_foreign_key ON policy(role_id);


CREATE TABLE role_permission
(
  role_id bigint NOT NULL,
  permission_id bigint NOT NULL,
  CONSTRAINT roles_permissions_pkey PRIMARY KEY (role_id , permission_id ),
  CONSTRAINT role_permission_role_foreign_key FOREIGN KEY (role_id) REFERENCES role (id)
   ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT role_permission_permission_foreign_key FOREIGN KEY (permission_id) REFERENCES permission (id)
   ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE INDEX fki_role_permission_role_foreign_key ON role_permission(role_id);
CREATE INDEX fki_role_permission_permission_foreign_key ON role_permission(permission_id);


set search_path=public;

