CREATE OR REPLACE FUNCTION acl.on_delete_group_trigger()
  RETURNS trigger AS
$BODY$BEGIN
DELETE FROM acl.policy WHERE agent_id=OLD.id;
RETURN NULL;
END;$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE OR REPLACE FUNCTION acl.on_delete_role_trigger()
  RETURNS trigger AS
$BODY$BEGIN
DELETE FROM acl.policy WHERE role_id=old.id;
RETURN NULL;
END;$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE TRIGGER on_delete_group
  AFTER DELETE
  ON acl."group"
  FOR EACH ROW
  EXECUTE PROCEDURE acl.on_delete_group_trigger();

CREATE TRIGGER on_delete_role
  AFTER DELETE
  ON acl.role
  FOR EACH ROW
  EXECUTE PROCEDURE acl.on_delete_role_trigger();

