set search_path=revision, public;

CREATE TABLE stable_branch (
    id bigserial NOT NULL,
    created timestamp with time zone NOT NULL DEFAULT now(),
    created_by bigint NOT NULL,
    finished timestamp with time zone,
    finished_by bigint NOT NULL default 0,
    attributes public.hstore,

    CONSTRAINT stable_branch_pkey PRIMARY KEY(id),
    CONSTRAINT valid_users CHECK (created_by > 0 and finished_by >=0)
);


CREATE UNIQUE INDEX one_open_branch_idx ON stable_branch USING btree (finished_by) WHERE finished_by = 0;


ALTER TABLE ONLY commit
    ALTER COLUMN stable SET DEFAULT FALSE,
    ALTER COLUMN created SET DATA TYPE timestamp with time zone,
    ADD COLUMN stable_branch_id bigint REFERENCES stable_branch (id),
    DROP CONSTRAINT IF EXISTS trunk_or_stable,
    ADD CONSTRAINT valid_stable_branch_id CHECK (stable_branch_id > 0),
    ADD CONSTRAINT stable_without_draft CHECK (stable_branch_id IS NULL OR state <> 'draft'),
    ADD CONSTRAINT trunk_or_stable_branch_id CHECK (trunk OR stable_branch_id > 0);

CREATE INDEX commit_stable_branch_id_idx ON commit USING btree (stable_branch_id);

set search_path=public;
