SET search_path=vrevisions_trunk, public;
CREATE TABLE suggest_data
(
  object_id bigint NOT NULL,
  commit_id bigint NOT NULL,
  text_data text NOT NULL,
  parent_id bigint,
  categories hstore NOT NULL,
  suggest_data_fts_russian tsvector,
  CONSTRAINT suggest_data_primary_key PRIMARY KEY (object_id )
);

CREATE INDEX suggest_data_categories_idx
  ON suggest_data
  USING gist
  (categories );


CREATE INDEX suggest_data_idx_russian
  ON suggest_data
  USING gin
  (suggest_data_fts_russian );

CREATE INDEX suggest_data_parent_id_idx
  ON suggest_data
  USING btree
  (parent_id , object_id );

CREATE TRIGGER suggest_data_tsvectorupdate_russian
  BEFORE INSERT OR UPDATE
  ON suggest_data
  FOR EACH ROW
  EXECUTE PROCEDURE tsvector_update_trigger('suggest_data_fts_russian', 'pg_catalog.russian', 'text_data');
SET search_path=public;
