set search_path=revision, public;

UPDATE object_revision SET next_stable_commit_id=0 WHERE next_stable_commit_id>0;
UPDATE commit SET stable_branch_id=NULL WHERE stable_branch_id IS NOT NULL;
ALTER TABLE commit DROP CONSTRAINT IF EXISTS commit_stable_branch_id_fkey;
ALTER TABLE commit DROP COLUMN IF EXISTS stable RESTRICT;
DROP TABLE IF EXISTS stable_branch CASCADE;


CREATE TYPE branch_type_type AS ENUM (
    'trunk',
    'stable',
    'archive',
    'deleted'
);

CREATE TYPE branch_state_type AS ENUM (
    'unavailable',
    'normal'
);

CREATE TABLE branch (
    id bigserial NOT NULL,
    type branch_type_type NOT NULL DEFAULT 'stable',
    state branch_state_type NOT NULL DEFAULT 'unavailable',
    created timestamp with time zone NOT NULL DEFAULT now(),
    created_by bigint NOT NULL,
    finished timestamp with time zone,
    finished_by bigint NOT NULL DEFAULT 0,
    attributes hstore,

    CONSTRAINT branch_pkey PRIMARY KEY(id),
    CONSTRAINT valid_trunk CHECK ((type='trunk' AND id=0 AND created_by=0) OR (type<>'trunk' AND id>0 AND created_by>0)),
    CONSTRAINT valid_finished CHECK ((type IN ('trunk','stable') AND finished_by=0) OR (type IN ('archive','deleted') AND finished_by>0)),
    CONSTRAINT valid_deleted CHECK (type<>'deleted' OR state='unavailable')
);


CREATE UNIQUE INDEX one_open_branch_idx ON branch USING btree (type) WHERE finished_by=0;
CREATE INDEX branch_type_idx ON branch USING btree (type);

INSERT INTO branch (id, type, state, created_by) VALUES (0, 'trunk', 'normal', 0);

ALTER TABLE COMMIT ADD CONSTRAINT commit_stable_branch_id_fkey FOREIGN KEY (stable_branch_id)
      REFERENCES revision.branch (id);

set search_path=public;
