SET search_path=revision,public;

ALTER TYPE branch_state_type RENAME TO old_branch_state_type;
ALTER TABLE branch RENAME COLUMN state TO old_state;

CREATE TYPE branch_state_type AS ENUM ('unavailable', 'normal', 'progress');
ALTER TABLE branch ADD COLUMN state branch_state_type NOT NULL DEFAULT 'unavailable';
UPDATE branch SET state=old_state::text::branch_state_type;

ALTER TABLE branch DROP CONSTRAINT valid_deleted, ADD CONSTRAINT valid_deleted CHECK (type<>'deleted' OR state='unavailable');

ALTER TABLE branch DROP COLUMN old_state;
DROP TYPE old_branch_state_type;


CREATE INDEX commit_trunk_idx ON commit USING btree (trunk);

SET search_path=public;
