SET search_path=vrevisions_trunk, public;

-- objects_p7
CREATE TABLE objects_p7
(
  CONSTRAINT objects_p7_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p7_zmin_check CHECK (zmin <= 7),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p7_commit_id_index ON objects_p7 USING btree (commit_id);

CREATE INDEX objects_p7_domain_attrs_gist ON objects_p7 USING gist (domain_attrs);

CREATE INDEX objects_p7_service_attrs_gist ON objects_p7 USING gist (service_attrs);

CREATE INDEX objects_p7_the_geom_index ON objects_p7 USING gist (the_geom);

CREATE INDEX objects_p7_zmax_index ON objects_p7 USING btree (zmax);

CREATE INDEX objects_p7_zmin_index ON objects_p7 USING btree (zmin);

-- objects_p8
CREATE TABLE objects_p8
(
  CONSTRAINT objects_p8_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p8_zmin_check CHECK (zmin >= 8 AND zmin < 10),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p8_commit_id_index ON objects_p8 USING btree (commit_id);

CREATE INDEX objects_p8_domain_attrs_gist ON objects_p8 USING gist (domain_attrs);

CREATE INDEX objects_p8_service_attrs_gist ON objects_p8 USING gist (service_attrs);

CREATE INDEX objects_p8_the_geom_index ON objects_p8 USING gist (the_geom);

CREATE INDEX objects_p8_zmax_index ON objects_p8 USING btree (zmax);

CREATE INDEX objects_p8_zmin_index ON objects_p8 USING btree (zmin);

-- objects_p10
CREATE TABLE objects_p10
(
  CONSTRAINT objects_p10_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p10_zmin_check CHECK (zmin >= 10 AND zmin < 12),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p10_commit_id_index ON objects_p10 USING btree (commit_id);

CREATE INDEX objects_p10_domain_attrs_gist ON objects_p10 USING gist (domain_attrs);

CREATE INDEX objects_p10_service_attrs_gist ON objects_p10 USING gist (service_attrs);

CREATE INDEX objects_p10_the_geom_index ON objects_p10 USING gist (the_geom);

CREATE INDEX objects_p10_zmax_index ON objects_p10 USING btree (zmax);

CREATE INDEX objects_p10_zmin_index ON objects_p10 USING btree (zmin);

-- objects_p12
CREATE TABLE objects_p12
(
  CONSTRAINT objects_p12_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p12_zmin_check CHECK (zmin >= 12 AND zmin < 14),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p12_commit_id_index ON objects_p12 USING btree (commit_id);

CREATE INDEX objects_p12_domain_attrs_gist ON objects_p12 USING gist (domain_attrs);

CREATE INDEX objects_p12_service_attrs_gist ON objects_p12 USING gist (service_attrs);

CREATE INDEX objects_p12_the_geom_index ON objects_p12 USING gist (the_geom);

CREATE INDEX objects_p12_zmax_index ON objects_p12 USING btree (zmax);

CREATE INDEX objects_p12_zmin_index ON objects_p12 USING btree (zmin);

-- objects_p14
CREATE TABLE objects_p14
(
  CONSTRAINT objects_p14_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p14_zmin_check CHECK (zmin >= 14 AND zmin < 16),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p14_commit_id_index ON objects_p14 USING btree (commit_id);

CREATE INDEX objects_p14_domain_attrs_gist ON objects_p14 USING gist (domain_attrs);

CREATE INDEX objects_p14_service_attrs_gist ON objects_p14 USING gist (service_attrs);

CREATE INDEX objects_p14_the_geom_index ON objects_p14 USING gist (the_geom);

CREATE INDEX objects_p14_zmax_index ON objects_p14 USING btree (zmax);

CREATE INDEX objects_p14_zmin_index ON objects_p14 USING btree (zmin);

-- objects_p16
CREATE TABLE objects_p16
(
  CONSTRAINT objects_p16_pkey PRIMARY KEY (id),
  CONSTRAINT objects_p16_zmin_check CHECK (zmin >= 16),
  CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
)
INHERITS (objects_p)
WITH ( OIDS=FALSE );


CREATE INDEX objects_p16_commit_id_index ON objects_p16 USING btree (commit_id);

CREATE INDEX objects_p16_domain_attrs_gist ON objects_p16 USING gist (domain_attrs);

CREATE INDEX objects_p16_service_attrs_gist ON objects_p16 USING gist (service_attrs);

CREATE INDEX objects_p16_the_geom_index ON objects_p16 USING gist (the_geom);

CREATE INDEX objects_p16_zmax_index ON objects_p16 USING btree (zmax);

CREATE INDEX objects_p16_zmin_index ON objects_p16 USING btree (zmin);

-- TRIGGERS
-- Function for main trigger to redirect insert
CREATE OR REPLACE FUNCTION objects_p_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF ( NEW.zmin >= 16) THEN
        INSERT INTO objects_p16 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_p14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_p12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_p10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_p8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7 ) THEN
        INSERT INTO objects_p7 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range.  Fix the objects_p_insert_trigger() function!';
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- Function for temporary upgrade time trigger, will remove at end
CREATE OR REPLACE FUNCTION objects_p_update_tmp_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    DELETE from objects_p where id = OLD.id;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- Function for partition triggers, expects target table zmin , zmax and name
CREATE OR REPLACE FUNCTION objects_p_update_trigger()
  RETURNS trigger AS
$BODY$
DECLARE
    table_zmin bigint;
    table_zmax bigint;
    table_name text;
BEGIN
    table_zmin = TG_ARGV[0];
    table_zmax = TG_ARGV[1];
    table_name = TG_ARGV[2];

    IF (NEW.zmin >= table_zmin AND NEW.zmin < table_zmax) THEN
        RETURN NEW;
    END IF;
    EXECUTE 'DELETE FROM ' || table_name::regclass || ' WHERE id = $1' USING OLD.id;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

-- Assign trigger functions to target tables
CREATE TRIGGER insert_objects_p_trigger BEFORE INSERT ON objects_p FOR EACH ROW
EXECUTE PROCEDURE objects_p_insert_trigger();

CREATE TRIGGER update_objects_p_tmp_trigger BEFORE UPDATE ON objects_p FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_tmp_trigger();

CREATE TRIGGER update_objects_p7_trigger BEFORE UPDATE ON objects_p7 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(0, 8, 'objects_p7');

CREATE TRIGGER update_objects_p8_trigger BEFORE UPDATE ON objects_p8 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(8, 10, 'objects_p8');

CREATE TRIGGER update_objects_p10_trigger BEFORE UPDATE ON objects_p10 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(10, 12, 'objects_p10');

CREATE TRIGGER update_objects_p12_trigger BEFORE UPDATE ON objects_p12 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(12, 14, 'objects_p12');

CREATE TRIGGER update_objects_p14_trigger BEFORE UPDATE ON objects_p14 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(14, 16, 'objects_p14');

CREATE TRIGGER update_objects_p16_trigger BEFORE UPDATE ON objects_p16 FOR EACH ROW
EXECUTE PROCEDURE objects_p_update_trigger(16, 30, 'objects_p16');

-- Execute upgrade
UPDATE objects_p SET zmin=zmin;

-- Remove temporary upgrade triggers
DROP TRIGGER update_objects_p_tmp_trigger ON objects_p;
DROP FUNCTION objects_p_update_tmp_trigger() ;

SET search_path=public;
