CREATE SCHEMA revision_meta;



SET search_path = revision_meta,public;

CREATE TABLE geometry (
    object_id bigint NOT NULL,
    commit_id bigint NOT NULL,
    branch_id bigint NOT NULL,
    the_geom geometry NOT NULL,
    categories hstore NOT NULL,

    CONSTRAINT geometry_pkey PRIMARY KEY (object_id, commit_id, branch_id),
    CONSTRAINT geometry_valid_ids CHECK (object_id > 0 AND commit_id > 0)
);



CREATE INDEX geometry_commit_branch_idx ON geometry USING btree (commit_id, branch_id);

SET search_path = public;
