CREATE FUNCTION mapspro_triggers_disable(in blind text) RETURNS VOID AS $$
DECLARE
    tabledesc RECORD;
BEGIN
    IF blind <> 'disable' THEN
        RAISE EXCEPTION 'Parameter Invalid'
            USING HINT = 'Please type text "disable" as parameter to function call';
    END IF;
    RAISE NOTICE 'Disabling all triggers!';
    FOR tabledesc IN SELECT * FROM pg_tables  WHERE tableowner='mapspro' and hastriggers LOOP
        EXECUTE 'ALTER TABLE '||tabledesc.schemaname||'.'||tabledesc.tablename||' DISABLE TRIGGER USER;';
    END LOOP;
END;
$$ LANGUAGE plpgsql;

CREATE FUNCTION mapspro_triggers_enable() RETURNS VOID AS $$
DECLARE
    tabledesc RECORD;
BEGIN
    RAISE NOTICE 'Enabling all triggers!';
    FOR tabledesc IN SELECT * FROM pg_tables  WHERE tableowner='mapspro' and hastriggers LOOP
        EXECUTE 'ALTER TABLE '||tabledesc.schemaname||'.'||tabledesc.tablename||' ENABLE TRIGGER USER;';
    END LOOP;
END;
$$ LANGUAGE plpgsql;
