SET search_path=public;

CREATE OR REPLACE FUNCTION for_vrevisions(in sql text) RETURNS setof text AS $$
DECLARE
    r RECORD;
BEGIN
    FOR r IN SELECT DISTINCT schemaname FROM pg_tables WHERE schemaname like 'vrevisions_%' ORDER BY 1 LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

SELECT for_vrevisions('
    DROP INDEX IF EXISTS objects_r_master_id_index;
    DROP INDEX IF EXISTS objects_r_service_attrs_gist;
');

SET search_path=public;
DROP FUNCTION for_vrevisions(in sql text);

