WITH new_content_id(old_id, new_id) AS
     (SELECT content_id
             , validation.insert_message_content(
                 (SELECT array_agg(unnest) FROM
                     (SELECT * FROM unnest(revision_ids)
                      ORDER BY split_part(unnest, ':', 1)::bigint
                               , split_part(unnest, ':', 2)::bigint) foo)
                 , the_geom)
      FROM validation.message_content WHERE array_length(revision_ids, 1) > 1)
UPDATE validation.task_message SET content_id = new_id
    FROM new_content_id WHERE old_id != new_id AND content_id = old_id;
