SET search_path=validation,public;

CREATE OR REPLACE FUNCTION message_content_hash(
    p_revision_ids text[],
    p_the_geom public.geometry)
RETURNS bytea AS
$$
BEGIN
    RETURN md5(COALESCE(public.st_asbinary(p_the_geom), ''::bytea)
               || array_to_string(p_revision_ids, ''));
END;
$$ LANGUAGE plpgsql IMMUTABLE;

SET search_path=public;
