SET search_path=public;

CREATE OR REPLACE FUNCTION for_vrevisions(in sql text) RETURNS setof text AS $$
DECLARE
    r RECORD;
BEGIN
    FOR r IN SELECT DISTINCT schemaname FROM pg_tables WHERE schemaname like 'vrevisions_%' ORDER BY 1 LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

SELECT for_vrevisions('
    ALTER TABLE objects_r
        ADD CONSTRAINT objects_r_geom_is_null CHECK (the_geom IS NULL);
    UPDATE objects_c SET the_geom = NULL WHERE the_geom IS NOT NULL;
    ALTER TABLE objects_c
        ADD CONSTRAINT objects_c_geom_is_null CHECK (the_geom IS NULL);
');

SET search_path=public;

