SET search_path=public;

CREATE OR REPLACE FUNCTION for_vrevisions(in sql text) RETURNS setof text AS $$
DECLARE
    r RECORD;
BEGIN
    FOR r IN SELECT DISTINCT schemaname FROM pg_tables WHERE schemaname like 'vrevisions_%' ORDER BY 1 LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

SELECT for_vrevisions('
    DROP INDEX IF EXISTS objects_commit_id_index;
    DROP INDEX IF EXISTS objects_a_commit_id_index;
    DROP INDEX IF EXISTS objects_c_commit_id_index;
    DROP INDEX IF EXISTS objects_l_commit_id_index;
    DROP INDEX IF EXISTS objects_p_commit_id_index;
    DROP INDEX IF EXISTS objects_a10_commit_id_index;
    DROP INDEX IF EXISTS objects_a12_commit_id_index;
    DROP INDEX IF EXISTS objects_a14_commit_id_index;
    DROP INDEX IF EXISTS objects_a16_commit_id_index;
    DROP INDEX IF EXISTS objects_a7_commit_id_index;
    DROP INDEX IF EXISTS objects_a8_commit_id_index;
    DROP INDEX IF EXISTS objects_l10_commit_id_index;
    DROP INDEX IF EXISTS objects_l12_commit_id_index;
    DROP INDEX IF EXISTS objects_l15_commit_id_index;
    DROP INDEX IF EXISTS objects_l9_commit_id_index;
    DROP INDEX IF EXISTS objects_p10_commit_id_index;
    DROP INDEX IF EXISTS objects_p12_commit_id_index;
    DROP INDEX IF EXISTS objects_p14_commit_id_index;
    DROP INDEX IF EXISTS objects_p16_commit_id_index;
    DROP INDEX IF EXISTS objects_p7_commit_id_index;
    DROP INDEX IF EXISTS objects_p8_commit_id_index;

    DROP INDEX IF EXISTS objects_a_area_index;
    DROP INDEX IF EXISTS objects_a10_area_index;
    DROP INDEX IF EXISTS objects_a12_area_index;
    DROP INDEX IF EXISTS objects_a14_area_index;
    DROP INDEX IF EXISTS objects_a16_area_index;
    DROP INDEX IF EXISTS objects_a7_area_index;
    DROP INDEX IF EXISTS objects_a8_area_index;

    DROP INDEX IF EXISTS objects_l_length_index;
    DROP INDEX IF EXISTS objects_l10_length_index;
    DROP INDEX IF EXISTS objects_l12_length_index;
    DROP INDEX IF EXISTS objects_l15_length_index;
    DROP INDEX IF EXISTS objects_l9_length_index;

    DROP INDEX IF EXISTS objects_c_the_geom_index;
    DROP INDEX IF EXISTS objects_c_zmin_index;
    DROP INDEX IF EXISTS objects_c_zmax_index;

    DROP INDEX IF EXISTS suggest_data_idx_text;
');

SET search_path=public;

