CREATE schema filters;

SET search_path = filters, public;

CREATE TABLE filter (
    filter_id bigserial PRIMARY KEY,

    created_at timestamp with time zone NOT NULL,
    created_by bigint NOT NULL CHECK (created_by > 0),
    is_deleted boolean NOT NULL DEFAULT false,

    name text NOT NULL,
    is_public boolean NOT NULL DEFAULT false,
    expression_id bigint NOT NULL
);


CREATE INDEX filter_created_by_index
    ON filter USING btree(created_by) WHERE is_deleted=FALSE;

CREATE TABLE filter_expression (
    expression_id bigserial PRIMARY KEY,
    expression_created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    expression_created_by bigint NOT NULL CHECK (expression_created_by > 0),
    lang_version text NOT NULL,
    expression text NOT NULL
);


SET search_path = public;
