SET search_path=social,public;

ALTER TABLE msg
    DROP COLUMN IF EXISTS branch,
    ADD COLUMN event_id bigint NOT NULL DEFAULT 0,
    ALTER COLUMN id TYPE bigint;

CREATE SEQUENCE event_id_seq
    INCREMENT 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    START 1
    CACHE 1;


CREATE TYPE resolve_resolution_type AS ENUM (
    'accept',
    'edit',
    'revert'
);

CREATE TYPE close_resolution_type AS ENUM (
    'approve',
    'edit',
    'revert'
);

CREATE TABLE task (
    event_id bigint NOT NULL DEFAULT nextval('event_id_seq'::regclass) PRIMARY KEY,
    commit_id bigint NOT NULL DEFAULT 0,
    resolved_by bigint NOT NULL DEFAULT 0,
    resolved_at timestamp with time zone,
    resolve_resolution resolve_resolution_type,
    closed_by bigint NOT NULL DEFAULT 0,
    closed_at timestamp with time zone,
    close_resolution close_resolution_type,
    locked_by bigint NOT NULL DEFAULT 0,
    locked_at timestamp with time zone
);



CREATE TABLE task_active
(
    CONSTRAINT task_active_pkey PRIMARY KEY (event_id),

    CONSTRAINT ckeck_zero_closed_by CHECK (closed_by = 0),
    CONSTRAINT ckeck_null_closed_at CHECK (closed_at IS NULL),
    CONSTRAINT ckeck_null_close_resolution CHECK (close_resolution IS NULL)
)
INHERITS (task);



CREATE TABLE task_closed
(
    CONSTRAINT task_closed_pkey PRIMARY KEY (event_id),

    CONSTRAINT check_resolved_by CHECK (resolved_by > 0),
    CONSTRAINT check_resolved_at CHECK (resolved_at IS NOT NULL),
    CONSTRAINT ckeck_resolve_resolution CHECK (resolve_resolution IS NOT NULL),

    CONSTRAINT ckeck_closed_by CHECK (closed_by > 0),
    CONSTRAINT check_closed_at CHECK (closed_at IS NOT NULL),
    CONSTRAINT ckeck_close_resolution CHECK (close_resolution IS NOT NULL),

    CONSTRAINT check_zero_locked_by CHECK (locked_by = 0),
    CONSTRAINT ckeck_null_locked_at CHECK (locked_at IS NULL)
)
INHERITS (task);



CREATE OR REPLACE FUNCTION task_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.close_resolution IS NULL) THEN
        INSERT INTO social.task_active VALUES (NEW.*);
    ELSE
        INSERT INTO social.task_closed VALUES (NEW.*);
    END IF;
    RETURN NULL;
END;
$$;


CREATE OR REPLACE FUNCTION task_active_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF (NEW.close_resolution IS NULL) THEN
        RETURN NEW;
    END IF;
    DELETE from social.task_active where event_id = OLD.event_id;
    INSERT INTO social.task_closed VALUES (NEW.*);
    RETURN NULL;
END;
$$;


CREATE TRIGGER task_insert_trigger BEFORE INSERT ON task
    FOR EACH ROW EXECUTE PROCEDURE task_insert_trigger();

CREATE TRIGGER task_active_update_trigger BEFORE UPDATE ON task_active
    FOR EACH ROW EXECUTE PROCEDURE task_active_update_trigger();

SET search_path=public;
