SET search_path = revision, public;

-- Clear tables

DELETE FROM object_revision
    WHERE commit_id IN (
        SELECT id
            FROM commit
            WHERE state = 'revoked'
    )
;

DELETE FROM commit
    WHERE state = 'revoked'
;

-- Remove constraints

ALTER TABLE commit ALTER COLUMN state
    DROP DEFAULT;

ALTER TABLE revision.commit
    DROP CONSTRAINT stable_without_draft;

-- Update enum type

ALTER TYPE commit_state_type
    RENAME TO commit_state_type_;

CREATE TYPE commit_state_type AS ENUM ('draft', 'approved');

ALTER TABLE commit ALTER COLUMN state TYPE commit_state_type
    USING state::text::commit_state_type;

DROP TYPE commit_state_type_;

-- Recover constraints for new type

ALTER TABLE commit ALTER COLUMN state
    SET DEFAULT 'draft'::commit_state_type;

ALTER TABLE commit ADD CONSTRAINT stable_without_draft
    CHECK (stable_branch_id IS NULL OR state <> 'draft'::commit_state_type);
