-- Create table
CREATE TYPE acl.ban_record_action_type AS ENUM (
    'ban',
    'unban'
);

CREATE TABLE acl.ban_record (
    br_id bigserial PRIMARY KEY,

    br_uid bigint REFERENCES acl."user" (uid) NOT NULL,
    br_action acl.ban_record_action_type NOT NULL,
    br_created timestamp with time zone NOT NULL DEFAULT now(),
    br_created_by bigint REFERENCES acl."user" (uid) NOT NULL,

    br_expires timestamp with time zone,
    br_reason text
);
CREATE INDEX ban_record_created_idx
    ON acl.ban_record (br_created DESC);
CREATE INDEX ban_record_uid_created_idx
    ON acl.ban_record (br_uid, br_created DESC);

-- Add reference from user
ALTER TABLE acl."user"
    ADD COLUMN current_ban_id bigint REFERENCES acl.ban_record (br_id);

-- Migrate old bans
INSERT INTO acl.ban_record (br_uid, br_action, br_created_by)
    SELECT uid, 'ban', 82282794 -- robot
        FROM acl."user" WHERE status = 'banned';
UPDATE acl."user" u
    SET current_ban_id =
        (SELECT br.br_id FROM acl.ban_record br WHERE br.br_uid = u.uid)
    WHERE u.status = 'banned';

-- Remove user status 'banned'
ALTER TYPE acl.user_status_type RENAME TO user_status_type_;

CREATE TYPE acl.user_status_type AS ENUM (
    'active',
    'deleted'
);

ALTER TABLE acl."user"
    ALTER COLUMN status DROP DEFAULT;
ALTER TABLE acl."user"
    ALTER COLUMN status SET DATA TYPE acl.user_status_type
        USING CASE status
            WHEN 'deleted' THEN 'deleted'::acl.user_status_type
            ELSE 'active'::acl.user_status_type
        END;
ALTER TABLE acl."user"
    ALTER COLUMN status SET DEFAULT 'active';

DROP TYPE acl.user_status_type_;
