SET search_path = social,public;

CREATE TYPE comment_type AS ENUM (
    'info',
    'complaint',
    'warn'
);

CREATE TABLE comment (
    id bigserial PRIMARY KEY,
    type comment_type NOT NULL,
    object_id bigint NOT NULL DEFAULT 0,
    commit_id bigint NOT NULL CHECK (commit_id > 0),
    created_by bigint NOT NULL CHECK (created_by > 0),
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),
    created_for bigint NOT NULL DEFAULT 0,
    read_at timestamp with time zone,
    deleted_by bigint NOT NULL DEFAULT 0,
    deleted_at timestamp with time zone,
    data text
);

CREATE INDEX comment_created_by_idx ON comment USING btree (created_by, created_at);
CREATE INDEX comment_created_at_idx ON comment USING btree (created_at);
CREATE INDEX comment_created_for_idx ON comment USING btree (created_for, created_at);
CREATE INDEX comment_object_id_idx ON comment USING btree (object_id, created_at) WHERE object_id > 0;

CREATE TABLE aoi_comment (
    aoi_id bigint NOT NULL,
    comment_id bigint NOT NULL,

    PRIMARY KEY (aoi_id, comment_id)
);

SET search_path = public;
