SET search_path = social,public;

CREATE TABLE commit_event (
       event_id bigint DEFAULT nextval('event_id_seq'::regclass) PRIMARY KEY,
       created_by bigint NOT NULL,
       created_at timestamp with time zone NOT NULL,

       branch_id bigint NOT NULL,
       commit_id bigint NOT NULL,
       action text NOT NULL,
       bounds text,

       primary_object_id bigint,
       primary_object_category_id text,
       primary_object_label text,
       primary_object_notes text,

       CONSTRAINT check_primary_object CHECK (
         (primary_object_id IS NULL
          AND primary_object_category_id IS NULL
          AND primary_object_label IS NULL
          AND primary_object_notes IS NULL)
         OR (primary_object_id IS NOT NULL
          AND primary_object_category_id IS NOT NULL
          AND primary_object_label IS NOT NULL
          AND primary_object_notes IS NOT NULL))
);

INSERT INTO commit_event
       (
       event_id, created_by, created_at,

       branch_id,
       commit_id,
       action,
       bounds,

       primary_object_id,
       primary_object_category_id,
       primary_object_label,
       primary_object_notes)
       SELECT event_id, uid, date,

              branch_id,
              (xpath('/data/e:commit/@id', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text::bigint,
              action,
              (xpath('/data/e:commit/e:bounds/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text,

              (xpath('/data/e:object/@id', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text::bigint,
              (xpath('/data/e:object/e:category-id/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text,
              CASE WHEN xpath_exists('/data/e:object', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']])
                   THEN COALESCE((xpath('/data/e:object/e:screen-label/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text, '')
                   ELSE NULL END,
              CASE WHEN xpath_exists('/data/e:object', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']])
                   THEN COALESCE((xpath('/data/e:object/e:edit-notes/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text, '')
                   ELSE NULL END
       FROM msg WHERE feed='user' AND xml_is_well_formed(data)
                AND event_id > 0;

CREATE INDEX commit_event_created_by_feed_idx ON commit_event
       USING btree(branch_id, created_by, event_id);

CREATE TABLE aoi_feed (
       branch_id bigint NOT NULL,
       aoi_id bigint NOT NULL,
       event_id bigint NOT NULL
);

INSERT INTO aoi_feed(branch_id, aoi_id, event_id)
       SELECT branch_id, subscriber, event_id FROM msg
           WHERE feed='aoi' AND event_id IN (SELECT event_id FROM commit_event);

ALTER TABLE aoi_feed ADD CONSTRAINT aoi_feed_pkey PRIMARY KEY(branch_id, aoi_id, event_id);

ALTER TABLE task ADD COLUMN created_at timestamp with time zone;
ALTER TABLE task ADD COLUMN primary_object_category_id text;

UPDATE task t
    SET created_at=c.created_at, primary_object_category_id=c.primary_object_category_id
    FROM commit_event c
    WHERE c.event_id=t.event_id AND t.created_at IS NULL;

CREATE INDEX task_active_category_idx
    ON task_active USING btree(primary_object_category_id, event_id);

SET search_path = public;
