SET search_path = social,public;

CREATE TEMPORARY TABLE missing_events(event_id bigint NOT NULL);
INSERT INTO missing_events(event_id)
       SELECT event_id FROM msg
       WHERE feed='user'
         AND event_id > 0
         AND xml_is_well_formed(data)
         AND NOT EXISTS (SELECT * FROM social.commit_event WHERE event_id=msg.event_id);

INSERT INTO commit_event
       (
       event_id, created_by, created_at,

       branch_id,
       commit_id,
       action,
       bounds,

       primary_object_id,
       primary_object_category_id,
       primary_object_label,
       primary_object_notes)
       SELECT event_id, uid, date,

              branch_id,
              (xpath('/data/e:commit/@id', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text::bigint,
              action,
              (xpath('/data/e:commit/e:bounds/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text,

              (xpath('/data/e:object/@id', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text::bigint,
              (xpath('/data/e:object/e:category-id/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text,
              CASE WHEN xpath_exists('/data/e:object', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']])
                   THEN COALESCE((xpath('/data/e:object/e:screen-label/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text, '')
                   ELSE NULL END,
              CASE WHEN xpath_exists('/data/e:object', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']])
                   THEN coalesce((xpath('/data/e:object/e:edit-notes/text()', data::xml, ARRAY[ARRAY['e', 'http://maps.yandex.ru/mapspro/editor/1.x']]))[1]::text, '')
                   ELSE NULL END
       FROM msg
       WHERE feed='user' AND event_id IN (SELECT event_id FROM missing_events);

INSERT INTO aoi_feed(branch_id, aoi_id, event_id)
       SELECT branch_id, subscriber, event_id
       FROM msg
       WHERE feed='aoi' AND event_id IN (SELECT event_id FROM missing_events);

UPDATE task t
    SET created_at=c.created_at, primary_object_category_id=c.primary_object_category_id
    FROM commit_event c
    WHERE c.event_id=t.event_id AND t.created_at IS NULL;
DELETE FROM task WHERE created_at IS NULL;

ALTER TABLE task ALTER COLUMN created_at SET NOT NULL;

SET search_path = public;
