CREATE SEQUENCE revision.approve_order_seq;

ALTER TABLE revision.commit ADD COLUMN approve_order bigint;

UPDATE revision.commit SET
    approve_order = CASE WHEN (state = 'approved' and trunk) THEN id ELSE 0 END
;

ALTER TABLE revision.commit
    ALTER COLUMN approve_order SET NOT NULL,
    ALTER COLUMN approve_order SET DEFAULT(0)
;

CREATE INDEX ON revision.commit USING btree(approve_order);

WITH w0 as (SELECT max(approve_order) FROM revision.commit)
SELECT setval(
    'revision.approve_order_seq',
    CASE WHEN w0.max = 0 THEN 1 ELSE w0.max END,
    CASE WHEN w0.max = 0 THEN false ELSE true END
)
FROM w0
;


