CREATE TABLE vrevisions_trunk.contour_objects_geom (
    object_id bigint NOT NULL,
    commit_id bigint NOT NULL,
    the_geom geometry(polygon, 3395),
    zmin integer NOT NULL DEFAULT 0,
    zmax integer,
    domain_attrs hstore,
    service_attrs hstore,
    area double precision,
    CONSTRAINT contour_objects_geom_object_id_check CHECK (object_id > 0),
    CONSTRAINT contour_objects_geom_commit_id_check CHECK (commit_id > 0)
);



CREATE INDEX contour_objects_geom_object_id_index
    ON vrevisions_trunk.contour_objects_geom
    USING btree (object_id);

CREATE INDEX contour_objects_geom_the_geom_index
    ON vrevisions_trunk.contour_objects_geom
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_zmin_index
    ON vrevisions_trunk.contour_objects_geom
    USING btree (zmin);

CREATE INDEX contour_objects_geom_zmax_index
    ON vrevisions_trunk.contour_objects_geom
    USING btree (zmax);

CREATE INDEX contour_objects_geom_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom
    USING gist (service_attrs);
