CREATE TEMPORARY TABLE event_geom(
       event_id bigint PRIMARY KEY,
       the_geom geometry);
INSERT INTO event_geom(event_id, the_geom)
       SELECT event_id,
              ST_Transform(
                  ST_MakeEnvelope(
                     (json(bounds)->>0)::float, (json(bounds)->>1)::float,
                     (json(bounds)->>2)::float, (json(bounds)->>3)::float,
                     4326),
                  3395)
       FROM social.commit_event WHERE abs((json(bounds)->>1)::float) <= 89
                                  AND bounds_geom IS NULL;

UPDATE social.commit_event
    SET bounds_geom = CASE WHEN ST_Area(the_geom) = 0
                           THEN ST_Expand(the_geom, 0.001)
                           ELSE the_geom END
    FROM event_geom WHERE commit_event.event_id = event_geom.event_id;

CREATE INDEX ON social.commit_event USING gist(bounds_geom);
