CREATE TABLE vrevisions_trunk.contour_objects_geom_09 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin <= 09)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_09_object_id_index
    ON vrevisions_trunk.contour_objects_geom_09
    USING btree (object_id);

CREATE INDEX contour_objects_geom_09_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_09
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_09_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_09
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_09_zmin_index
    ON vrevisions_trunk.contour_objects_geom_09
    USING btree (zmin);

CREATE INDEX contour_objects_geom_09_zmax_index
    ON vrevisions_trunk.contour_objects_geom_09
    USING btree (zmax);

CREATE INDEX contour_objects_geom_09_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_09
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_09_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_09
    USING gist (service_attrs);



CREATE TABLE vrevisions_trunk.contour_objects_geom_10 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin = 10)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_10_object_id_index
    ON vrevisions_trunk.contour_objects_geom_10
    USING btree (object_id);

CREATE INDEX contour_objects_geom_10_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_10
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_10_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_10
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_10_zmax_index
    ON vrevisions_trunk.contour_objects_geom_10
    USING btree (zmax);

CREATE INDEX contour_objects_geom_10_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_10
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_10_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_10
    USING gist (service_attrs);



CREATE TABLE vrevisions_trunk.contour_objects_geom_11 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin = 11)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_11_object_id_index
    ON vrevisions_trunk.contour_objects_geom_11
    USING btree (object_id);

CREATE INDEX contour_objects_geom_11_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_11
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_11_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_11
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_11_zmax_index
    ON vrevisions_trunk.contour_objects_geom_11
    USING btree (zmax);

CREATE INDEX contour_objects_geom_11_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_11
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_11_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_11
    USING gist (service_attrs);



CREATE TABLE vrevisions_trunk.contour_objects_geom_12 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin = 12)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_12_object_id_index
    ON vrevisions_trunk.contour_objects_geom_12
    USING btree (object_id);

CREATE INDEX contour_objects_geom_12_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_12
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_12_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_12
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_12_zmax_index
    ON vrevisions_trunk.contour_objects_geom_12
    USING btree (zmax);

CREATE INDEX contour_objects_geom_12_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_12
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_12_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_12
    USING gist (service_attrs);



CREATE TABLE vrevisions_trunk.contour_objects_geom_13 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin = 13)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_13_object_id_index
    ON vrevisions_trunk.contour_objects_geom_13
    USING btree (object_id);

CREATE INDEX contour_objects_geom_13_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_13
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_13_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_13
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_13_zmax_index
    ON vrevisions_trunk.contour_objects_geom_13
    USING btree (zmax);

CREATE INDEX contour_objects_geom_13_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_13
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_13_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_13
    USING gist (service_attrs);



CREATE TABLE vrevisions_trunk.contour_objects_geom_14 (
    CONSTRAINT contour_objects_geom_zmin_check CHECK (zmin >= 14)
) INHERITS (vrevisions_trunk.contour_objects_geom);


CREATE INDEX contour_objects_geom_14_object_id_index
    ON vrevisions_trunk.contour_objects_geom_14
    USING btree (object_id);

CREATE INDEX contour_objects_geom_14_the_geom_index
    ON vrevisions_trunk.contour_objects_geom_14
    USING gist (the_geom);

CREATE INDEX contour_objects_geom_14_the_geom_domain_attrs_index
    ON vrevisions_trunk.contour_objects_geom_14
    USING gist (the_geom, domain_attrs);

CREATE INDEX contour_objects_geom_14_zmin_index
    ON vrevisions_trunk.contour_objects_geom_14
    USING btree (zmin);

CREATE INDEX contour_objects_geom_14_zmax_index
    ON vrevisions_trunk.contour_objects_geom_14
    USING btree (zmax);

CREATE INDEX contour_objects_geom_14_domain_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_14
    USING gist (domain_attrs);

CREATE INDEX contour_objects_geom_14_service_attrs_gist
    ON vrevisions_trunk.contour_objects_geom_14
    USING gist (service_attrs);



CREATE FUNCTION vrevisions_trunk.contour_objects_geom_insert_trigger()
    RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 14) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_14 VALUES (NEW.*);
    ELSIF (NEW.zmin = 13) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_13 VALUES (NEW.*);
    ELSIF (NEW.zmin = 12) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_12 VALUES (NEW.*);
    ELSIF (NEW.zmin = 11) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_11 VALUES (NEW.*);
    ELSIF (NEW.zmin = 10) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_10 VALUES (NEW.*);
    ELSIF (NEW.zmin <= 9) THEN
        INSERT INTO vrevisions_trunk.contour_objects_geom_09 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range. Fix the contour_objects_geom_insert_trigger() function!';
    END IF;
RETURN NULL;
END;
$BODY$
    LANGUAGE plpgsql VOLATILE
    COST 100;


CREATE TRIGGER insert_contour_objects_trigger
    BEFORE INSERT
    ON vrevisions_trunk.contour_objects_geom
    FOR EACH ROW
    EXECUTE PROCEDURE vrevisions_trunk.contour_objects_geom_insert_trigger();


