ALTER TABLE social.stats
    ADD COLUMN edits_7d_ago bigint DEFAULT 0,
    ADD COLUMN edits_30d_ago bigint DEFAULT 0,
    ADD COLUMN edits_90d_ago bigint DEFAULT 0;

CREATE SCHEMA rating;
CREATE TABLE rating.full (
    pos bigint PRIMARY KEY,
    uid bigint NOT NULL,
    score double precision NOT NULL);
CREATE UNIQUE INDEX full_uid_idx ON rating.full (uid);

CREATE TABLE rating.week (LIKE rating.full INCLUDING ALL);
CREATE TABLE rating.month (LIKE rating.full INCLUDING ALL);
CREATE TABLE rating.quarter (LIKE rating.full INCLUDING ALL);

CREATE TABLE rating.meta (
    type text PRIMARY KEY,
    version bigint NOT NULL,
    size bigint NOT NULL);
INSERT INTO rating.meta VALUES
    ('full', 0, 0), ('week', 0, 0), ('month', 0, 0), ('quarter', 0, 0);
