SET search_path = social,public;

BEGIN;
LOCK TABLE task IN SHARE MODE;
LOCK TABLE aoi_feed IN EXCLUSIVE MODE;

ALTER TABLE aoi_feed RENAME TO old_aoi_feed;


CREATE TABLE aoi_feed (
    aoi_id bigint NOT NULL,
    event_id bigint NOT NULL
);

CREATE TABLE aoi_feed_stable (
    branch_id bigint NOT NULL CHECK (branch_id != 0)
)
INHERITS (aoi_feed);

CREATE TABLE aoi_feed_trunk (
)
INHERITS (aoi_feed);

CREATE TABLE aoi_feed_trunk_without_task (
)
INHERITS (aoi_feed_trunk);

CREATE TABLE aoi_feed_trunk_task (
)
INHERITS (aoi_feed_trunk);

CREATE TABLE aoi_feed_trunk_task_active (
)
INHERITS (aoi_feed_trunk_task);

CREATE TABLE aoi_feed_trunk_task_closed (
)
INHERITS (aoi_feed_trunk_task);

CREATE FUNCTION aoi_feed_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    RAISE EXCEPTION 'Not insertable table aoi_feed';
END;
$$;

CREATE TRIGGER aoi_feed_insert_trigger BEFORE INSERT ON aoi_feed
    FOR EACH STATEMENT EXECUTE PROCEDURE aoi_feed_insert_trigger();
CREATE TRIGGER aoi_feed_trunk_insert_trigger BEFORE INSERT ON aoi_feed_trunk
    FOR EACH STATEMENT EXECUTE PROCEDURE aoi_feed_insert_trigger();
CREATE TRIGGER aoi_feed_trunk_task_insert_trigger BEFORE INSERT ON aoi_feed_trunk_task
    FOR EACH STATEMENT EXECUTE PROCEDURE aoi_feed_insert_trigger();


CREATE FUNCTION task_active_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    INSERT INTO social.aoi_feed_trunk_task_active
        SELECT * FROM social.aoi_feed_trunk_without_task WHERE event_id = NEW.event_id;
    DELETE FROM social.aoi_feed_trunk_without_task WHERE event_id = NEW.event_id;
    RETURN NULL;
END;
$$;

CREATE FUNCTION task_closed_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    INSERT INTO social.aoi_feed_trunk_task_closed
        SELECT * FROM social.aoi_feed_trunk_task_active WHERE event_id = NEW.event_id;
    DELETE FROM social.aoi_feed_trunk_task_active WHERE event_id = NEW.event_id;
    RETURN NULL;
END;
$$;

CREATE TRIGGER task_active_insert_trigger AFTER INSERT ON task_active
    FOR EACH ROW EXECUTE PROCEDURE task_active_insert_trigger();
CREATE TRIGGER task_closed_insert_trigger AFTER INSERT ON task_closed
    FOR EACH ROW EXECUTE PROCEDURE task_closed_insert_trigger();


INSERT INTO aoi_feed_stable (aoi_id, event_id, branch_id)
    SELECT aoi_id, event_id, branch_id FROM old_aoi_feed
        WHERE branch_id!=0;
INSERT INTO aoi_feed_trunk_task_active
    SELECT aoi_id, event_id FROM old_aoi_feed
        WHERE event_id IN (SELECT event_id FROM social.task_active);
INSERT INTO aoi_feed_trunk_task_closed
    SELECT aoi_id, event_id FROM old_aoi_feed
        WHERE event_id IN (SELECT event_id FROM social.task_closed);
INSERT INTO aoi_feed_trunk_without_task
    SELECT aoi_id, event_id FROM old_aoi_feed
        WHERE branch_id=0 AND event_id NOT IN (SELECT event_id FROM social.task);


DROP TABLE old_aoi_feed;


ALTER TABLE aoi_feed
    ADD CONSTRAINT aoi_feed_pkey PRIMARY KEY(aoi_id, event_id);
ALTER TABLE aoi_feed_stable
    ADD CONSTRAINT aoi_feed_stable_pkey PRIMARY KEY(branch_id, aoi_id, event_id);
ALTER TABLE aoi_feed_trunk
    ADD CONSTRAINT aoi_feed_trunk_pkey PRIMARY KEY(aoi_id, event_id);
ALTER TABLE aoi_feed_trunk_without_task
    ADD CONSTRAINT aoi_feed_trunk_without_task_pkey PRIMARY KEY(aoi_id, event_id);
ALTER TABLE aoi_feed_trunk_task
    ADD CONSTRAINT aoi_feed_trunk_task_pkey PRIMARY KEY(aoi_id, event_id);
ALTER TABLE aoi_feed_trunk_task_active
    ADD CONSTRAINT aoi_feed_trunk_task_active_pkey PRIMARY KEY(aoi_id, event_id);
ALTER TABLE aoi_feed_trunk_task_closed
    ADD CONSTRAINT aoi_feed_trunk_task_closed_pkey PRIMARY KEY(aoi_id, event_id);


CREATE INDEX aoi_feed_event_id_idx ON aoi_feed USING btree (event_id);
CREATE INDEX aoi_feed_stable_event_id_idx ON aoi_feed_stable USING btree (event_id);
CREATE INDEX aoi_feed_trunk_event_id_idx ON aoi_feed_trunk USING btree (event_id);
CREATE INDEX aoi_feed_trunk_without_task_event_id_idx ON aoi_feed_trunk_without_task USING btree (event_id);
CREATE INDEX aoi_feed_trunk_task_event_id_idx ON aoi_feed_trunk_task USING btree (event_id);
CREATE INDEX aoi_feed_trunk_task_active_event_id_idx ON aoi_feed_trunk_task_active USING btree (event_id);
CREATE INDEX aoi_feed_trunk_task_closed_event_id_idx ON aoi_feed_trunk_task_closed USING btree (event_id);

COMMIT;
SET search_path = public;
