CREATE TABLE social.involvements
(
    id bigserial NOT NULL,
    title text NOT NULL,
    url text NOT NULL,
    category_ids text[] NOT NULL,
    enabled boolean NOT NULL,
    start timestamp with time zone NOT NULL,
    finish timestamp with time zone,
    PRIMARY KEY(id)
);
CREATE INDEX ON social.involvements USING btree(enabled);
CREATE INDEX ON social.involvements USING btree(start);
CREATE INDEX ON social.involvements USING btree(finish);

CREATE TABLE social.involvement_stats
(
    involvement_id bigint NOT NULL REFERENCES social.involvements(id),
    category_id text NOT NULL,
    objects_created bigint NOT NULL DEFAULT 0,
    PRIMARY KEY(involvement_id, category_id)
);
CREATE INDEX ON social.involvement_stats USING btree(involvement_id);
