CREATE SCHEMA mds_dataset;


CREATE TABLE mds_dataset.export_meta(
    id text NOT NULL PRIMARY KEY,
    status smallint NOT NULL,
    created timestamp with time zone NOT NULL,
    subset smallint NOT NULL
);

COMMENT ON TABLE mds_dataset.export_meta IS
    'Metadata of export dataset';

COMMENT ON COLUMN mds_dataset.export_meta.status IS
    'Dataset status'
    '<glossary>'
        '<item value="0" description="Available"/>'
        '<item value="1" description="Incomplete"/>'
        '<item value="2" description="Deleting"/>'
        '<item value="3" description="Deleted"/>'
    '</glossary>';

COMMENT ON COLUMN mds_dataset.export_meta.subset IS
    'Export dataset subset'
    '<glossary>'
        '<item value="0" description="Ymapsdf"/>'
        '<item value="1" description="Service"/>'
        '<item value="2" description="Masstransit"/>'
    '</glossary>';



CREATE TABLE mds_dataset.export_files(
    dataset_id text REFERENCES mds_dataset.export_meta(id) ON DELETE CASCADE,
    mds_group_id text NOT NULL,
    mds_path text NOT NULL,
    name text NOT NULL,
    url text NOT NULL,
    CONSTRAINT export_files_pkey PRIMARY KEY(dataset_id, mds_group_id, mds_path)
);


CREATE INDEX export_meta_status_idx ON mds_dataset.export_meta USING btree (status);
CREATE INDEX export_meta_created_idx ON mds_dataset.export_meta USING btree (created);
CREATE INDEX export_meta_subset_idx ON mds_dataset.export_meta USING btree (subset);

