CREATE TYPE social.event_type AS ENUM (
    'edit',
    'complaint',
    'request-for-deletion',
    'closed-feedback'
);


ALTER TABLE social.commit_event
    ADD COLUMN type social.event_type NOT NULL DEFAULT 'edit';

ALTER INDEX social.commit_event_commit_id_idx RENAME TO old_commit_event_commit_id_idx;
CREATE UNIQUE INDEX commit_event_commit_id_idx ON social.commit_event
    USING btree (commit_id) WHERE type='edit';
DROP INDEX social.old_commit_event_commit_id_idx;


ALTER TABLE social.comment ADD COLUMN event_id bigint;
CREATE INDEX comment_event_id_idx ON social.comment USING btree (event_id);


ALTER TABLE social.task
    ADD COLUMN type social.event_type NOT NULL DEFAULT 'edit';
