CREATE SCHEMA IF NOT EXISTS vrevisions;

SET search_path=vrevisions,public;

CREATE OR REPLACE FUNCTION vrevisions.for_vrevisions(IN sql text, IN skip_schemaname text DEFAULT '')
    RETURNS setof text AS $$
DECLARE
    r RECORD;
BEGIN
    FOR r IN
      SELECT DISTINCT schemaname FROM pg_tables
       WHERE schemaname like 'vrevisions_%' AND schemaname != skip_schemaname
       ORDER BY 1
      LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION vrevisions.for_vrevisions_stable(IN sql text, IN skip_schemaname text DEFAULT '')
    RETURNS setof text AS $$
DECLARE
    r RECORD;
BEGIN
    FOR r IN
      SELECT DISTINCT schemaname FROM pg_tables
       WHERE schemaname like 'vrevisions_stable_%' AND schemaname != skip_schemaname
       ORDER BY 1
      LOOP
        EXECUTE 'SET search_path='||r.schemaname||',public;'||sql;
        RETURN NEXT r.schemaname;
    END LOOP;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION vrevisions.create_highlight_views()
    RETURNS void AS $$
BEGIN
    CREATE OR REPLACE VIEW complex_objects_highlight_view AS
    SELECT r.master_id,
        r.slave_id AS id,
        r.domain_attrs -> 'rel:slave'::text AS slave_category,
        r.domain_attrs -> 'rel:role'::text AS slave_role,
        s.the_geom,
        s.zmin,
        s.zmax
    FROM objects_r r, objects s
    WHERE r.slave_id = s.id AND s.the_geom IS NOT NULL;

    CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
    SELECT r.master_id,
        s.id,
        s.the_geom,
        s.zmin,
        s.zmax,
        r.domain_attrs,
        r.slave_id
    FROM objects_r r, objects_r r_next, objects_l s
    WHERE r.slave_id = r_next.master_id AND r_next.slave_id = s.id;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION vrevisions.create_suggest_views()
    RETURNS void AS $$
BEGIN
    CREATE OR REPLACE VIEW complex_objects_slaves_view AS
    SELECT r.master_id,
        r.slave_id AS id,
        r.domain_attrs -> 'rel:slave'::text AS slave_category,
        r.domain_attrs -> 'rel:role'::text AS slave_role,
        s.the_geom,
        r.domain_attrs -> 'rel:master'::text AS master_category
    FROM objects_r r, objects s
    WHERE r.slave_id = s.id AND s.the_geom IS NOT NULL;

    CREATE OR REPLACE VIEW contour_objects_elements_view AS
    SELECT r.master_id,
        r.domain_attrs -> 'rel:master'::text AS master_category,
        s.id,
        s.the_geom,
        s.zmin,
        s.zmax,
        s.domain_attrs AS element_attrs,
        s.service_attrs,
        s.commit_id
    FROM objects_r r, objects_r r_next, objects_l s
    WHERE r.slave_id = r_next.master_id AND r_next.slave_id = s.id;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION vrevisions.create_complex_objects_views()
    RETURNS void AS $$
BEGIN
    EXECUTE vrevisions.create_highlight_views();
    EXECUTE vrevisions.create_suggest_views();
END;
$$ LANGUAGE plpgsql;


SELECT vrevisions.for_vrevisions('
    ALTER TABLE IF EXISTS objects_r RENAME TO objects_r_old;
    ALTER INDEX objects_r_pkey RENAME TO objects_r_old_pkey;
');


CREATE TABLE IF NOT EXISTS vrevisions_trunk.objects_r
(
    id bigint NOT NULL,
    commit_id bigint NOT NULL CHECK (commit_id > 0),
    domain_attrs hstore,
    master_id bigint NOT NULL CHECK (master_id > 0),
    slave_id bigint NOT NULL CHECK (slave_id > 0)
);

INSERT INTO vrevisions_trunk.objects_r (id,commit_id,master_id,slave_id,domain_attrs)
    SELECT id,commit_id,master_id,slave_id,domain_attrs
    FROM vrevisions_trunk.objects_r_old;

ALTER TABLE vrevisions_trunk.objects_r
    ADD CONSTRAINT objects_r_pkey PRIMARY KEY (id);
CREATE INDEX objects_r_master_id_slave_id_idx
    ON vrevisions_trunk.objects_r USING btree (master_id, slave_id);
CREATE INDEX objects_r_slave_id_idx
    ON vrevisions_trunk.objects_r USING btree (slave_id);

SELECT vrevisions.for_vrevisions_stable('
    CREATE TABLE objects_r
        (LIKE vrevisions_trunk.objects_r INCLUDING ALL);
');

SELECT vrevisions.for_vrevisions('
    SELECT vrevisions.create_complex_objects_views();
');

SET search_path=public;
