CREATE TABLE service.releases_notification_task (
    id bigint PRIMARY KEY REFERENCES service.task (id),
    release_type text NOT NULL,
    blog_url text NOT NULL,
    mode text NOT NULL,
    sent_notifications_num bigint,

    CONSTRAINT release_types_constraint CHECK (release_type IN ('vec', 'sat')),
    CONSTRAINT modes_constraint CHECK (mode IN ('dry', 'test', 'real'))
);


CREATE TABLE service.releases_notification_vec_task (
    id bigint PRIMARY KEY REFERENCES service.releases_notification_task (id),
    since_branch_id bigint NOT NULL,
    till_branch_id bigint NOT NULL
);

CREATE TABLE service.releases_notification_sat_task (
    id bigint PRIMARY KEY REFERENCES service.releases_notification_task (id),
    geom geometry NOT NULL
);

CREATE TABLE service.releases_notification_email (
    id bigserial PRIMARY KEY,
    task_id bigint REFERENCES service.releases_notification_task (id),
    email text NOT NULL,
    status text NOT NULL DEFAULT 'scheduled',

    CONSTRAINT status_constraint CHECK (status IN ('scheduled', 'sent'))
);
