DROP TABLE IF EXISTS service.releases_notification_task CASCADE;
DROP TABLE IF EXISTS service.releases_notification_vec_task CASCADE;
DROP TABLE IF EXISTS service.releases_notification_sat_task CASCADE;
DROP TABLE IF EXISTS service.releases_notification_email CASCADE;

DELETE FROM service.task WHERE service.task.type = 'releases_notification';
DELETE FROM service.task WHERE service.task.type = 'releases_notification_vec';
DELETE FROM service.task WHERE service.task.type = 'releases_notification_sat';

CREATE TABLE service.releases_notification_task (
    id bigint PRIMARY KEY REFERENCES service.task (id),
    release_type text NOT NULL,
    blog_url text NOT NULL,
    mode text NOT NULL,
    sent_notifications_num bigint,

    CONSTRAINT release_types_constraint CHECK (release_type IN ('vec', 'sat')),
    CONSTRAINT modes_constraint CHECK (mode IN ('dry', 'test', 'real'))
);


CREATE TABLE service.releases_notification_vec_param (
    param_id bigserial PRIMARY KEY,
    task_id bigint REFERENCES service.releases_notification_task (id),
    since_branch_id bigint NOT NULL,
    till_branch_id bigint NOT NULL
);

CREATE TABLE service.releases_notification_sat_param (
    param_id bigserial PRIMARY KEY,
    task_id bigint REFERENCES service.releases_notification_task (id),
    geom geometry NOT NULL
);

CREATE TABLE service.releases_notification_email (
    id bigserial PRIMARY KEY,
    task_id bigint REFERENCES service.releases_notification_task (id),
    email text NOT NULL,
    status text NOT NULL DEFAULT 'scheduled',

    CONSTRAINT status_constraint CHECK (status IN ('scheduled', 'sent'))
);
