SET search_path=vrevisions,public;

CREATE OR REPLACE FUNCTION vrevisions.create_highlight_views()
    RETURNS void AS $$
BEGIN
    CREATE OR REPLACE VIEW complex_objects_highlight_view AS
    SELECT r.master_id,
        r.slave_id AS id,
        r.domain_attrs -> 'rel:slave'::text AS slave_category,
        r.domain_attrs -> 'rel:role'::text AS slave_role,
        s.the_geom,
        s.zmin,
        s.zmax
    FROM objects_r r, objects s
    WHERE r.slave_id = s.id AND s.the_geom IS NOT NULL;

    CREATE OR REPLACE VIEW complex_objects_l_highlight_view AS
    SELECT r.master_id,
        r.slave_id AS id,
        r.domain_attrs -> 'rel:slave'::text AS slave_category,
        r.domain_attrs -> 'rel:role'::text AS slave_role,
        s.the_geom,
        s.zmin,
        s.zmax
    FROM objects_r r, objects_l s
    WHERE r.slave_id = s.id;

    CREATE OR REPLACE VIEW complex_objects_p_highlight_view AS
    SELECT r.master_id,
        r.slave_id AS id,
        r.domain_attrs -> 'rel:slave'::text AS slave_category,
        r.domain_attrs -> 'rel:role'::text AS slave_role,
        s.the_geom,
        s.zmin,
        s.zmax
    FROM objects_r r, objects_p s
    WHERE r.slave_id = s.id;

    CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
    SELECT r.master_id,
        s.id,
        s.the_geom,
        s.zmin,
        s.zmax,
        r.domain_attrs,
        r.slave_id
    FROM objects_r r, objects_r r_next, objects_l s
    WHERE r.slave_id = r_next.master_id AND r_next.slave_id = s.id;
END;
$$ LANGUAGE plpgsql;

SELECT vrevisions.for_vrevisions('
    SELECT vrevisions.create_highlight_views();
');

SET search_path=public;
