CREATE OR REPLACE FUNCTION vrevisions.bbox_parts()
  RETURNS geometry[] AS
$BODY$
BEGIN
  RETURN ARRAY[
    ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,4500001), ST_Point(7000000,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,4500001), ST_Point(2000000,147687969)),3395)];

    --ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,-147687969), ST_Point(7000000,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,-147687969), ST_Point(2000000,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-20037483,-147687969), ST_Point(-3000001,7500000)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-20037483,7500001), ST_Point(-4500001,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,-147687969), ST_Point(20037483,4500000)),3395)
END;
$BODY$
LANGUAGE plpgsql IMMUTABLE COST 1;


CREATE OR REPLACE FUNCTION vrevisions.get_part(the_geom in geometry)
    RETURNS integer AS
$BODY$
DECLARE
    geom geometry := ST_SetSRID(the_geom, 3395);
    part integer := 1;
    bbox geometry;
BEGIN
    FOREACH bbox IN ARRAY vrevisions.bbox_parts() LOOP
        IF (geom @ bbox) THEN
            RETURN part;
        END IF;
        part := part + 1;
    END LOOP;
    RETURN 0;
END;
$BODY$
LANGUAGE plpgsql IMMUTABLE COST 1;


CREATE OR REPLACE FUNCTION vrevisions.get_parts(
    x1 in double precision,
    y1 in double precision,
    x2 in double precision,
    y2 in double precision)
  RETURNS integer[] AS
$BODY$
DECLARE
    geom geometry := ST_SetSRID(ST_MakeBox2D(ST_Point(x1,y1), ST_Point(x2,y2)),3395);
    part integer := 0;
    parts integer[] := ARRAY[0];
    bbox geometry;
BEGIN
    FOREACH bbox IN ARRAY vrevisions.bbox_parts() LOOP
        part := part + 1;
        IF (geom && bbox) THEN
            parts := parts || part;
        END IF;
    END LOOP;
    RETURN parts;
END;
$BODY$
LANGUAGE plpgsql IMMUTABLE COST 10;
