SELECT vrevisions.for_vrevisions('
ALTER TABLE objects_a ADD COLUMN part integer;


CREATE TABLE objects_a16_part0 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=0)
)
INHERITS (objects_a);

CREATE TABLE objects_a16_part1 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=1)
)
INHERITS (objects_a);

CREATE TABLE objects_a16_part2 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=2)
)
INHERITS (objects_a);

CREATE TABLE objects_a16_part3 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=3)
)
INHERITS (objects_a);

CREATE INDEX objects_a16_part0_the_geom_center_domain_service_attrs_idx
    ON objects_a16_part0
    USING gist
    (the_geom, the_center, domain_attrs, service_attrs);

CREATE INDEX objects_a16_part1_the_geom_center_domain_service_attrs_idx
    ON objects_a16_part1
    USING gist
    (the_geom, the_center, domain_attrs, service_attrs);

CREATE INDEX objects_a16_part2_the_geom_center_domain_service_attrs_idx
    ON objects_a16_part2
    USING gist
    (the_geom, the_center, domain_attrs, service_attrs);

CREATE INDEX objects_a16_part3_the_geom_center_domain_service_attrs_idx
    ON objects_a16_part3
    USING gist
    (the_geom, the_center, domain_attrs, service_attrs);


CREATE OR REPLACE FUNCTION objects_a_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := vrevisions.get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_a16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_a16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_a16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_a16_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_a_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_a14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_a12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_a10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_a8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7 ) THEN
        INSERT INTO objects_a7 VALUES (NEW.*); 
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_a_insert_trigger() function!'';
    END IF;        
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a7_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin <= 7) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a7 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a8_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 8 AND NEW.zmin < 10) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a8 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a10_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 10 AND NEW.zmin < 12) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a10 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 14) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a12 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a14_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 14 AND NEW.zmin < 16) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a14 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16 AND NEW.part = OLD.part) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;


CREATE TRIGGER update_objects_a16_part0_trigger
    BEFORE UPDATE
    ON objects_a16_part0
    FOR EACH ROW
    EXECUTE PROCEDURE objects_a16_update_trigger();

CREATE TRIGGER update_objects_a16_part1_trigger
    BEFORE UPDATE
    ON objects_a16_part1
    FOR EACH ROW
    EXECUTE PROCEDURE objects_a16_update_trigger();

CREATE TRIGGER update_objects_a16_part2_trigger
    BEFORE UPDATE
    ON objects_a16_part2
    FOR EACH ROW
    EXECUTE PROCEDURE objects_a16_update_trigger();

CREATE TRIGGER update_objects_a16_part3_trigger
    BEFORE UPDATE
    ON objects_a16_part3
    FOR EACH ROW
    EXECUTE PROCEDURE objects_a16_update_trigger();
');
