SELECT vrevisions.for_vrevisions('
ALTER TABLE objects_l ADD COLUMN part integer;


CREATE TABLE objects_l12_part0 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 12 AND zmin < 15),
    CHECK (part=0)
)
INHERITS (objects_l);

CREATE TABLE objects_l12_part1 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 12 AND zmin < 15),
    CHECK (part=1)
)
INHERITS (objects_l);

CREATE TABLE objects_l12_part2 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 12 AND zmin < 15),
    CHECK (part=2)
)
INHERITS (objects_l);

CREATE TABLE objects_l12_part3 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 12 AND zmin < 15),
    CHECK (part=3)
)
INHERITS (objects_l);


CREATE TABLE objects_l15_part0 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 15),
    CHECK (part=0)
)
INHERITS (objects_l);

CREATE TABLE objects_l15_part1 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 15),
    CHECK (part=1)
)
INHERITS (objects_l);

CREATE TABLE objects_l15_part2 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 15),
    CHECK (part=2)
)
INHERITS (objects_l);

CREATE TABLE objects_l15_part3 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 15),
    CHECK (part=3)
)
INHERITS (objects_l);


CREATE INDEX objects_l12_part0_the_geom_domain_service_attrs_idx
    ON objects_l12_part0
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l12_part1_the_geom_domain_service_attrs_idx
    ON objects_l12_part1
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l12_part2_the_geom_domain_service_attrs_idx
    ON objects_l12_part2
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l12_part3_the_geom_domain_service_attrs_idx
    ON objects_l12_part3
    USING gist
    (the_geom, domain_attrs, service_attrs);


CREATE INDEX objects_l15_part0_the_geom_domain_service_attrs_idx
    ON objects_l15_part0
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l15_part1_the_geom_domain_service_attrs_idx
    ON objects_l15_part1
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l15_part2_the_geom_domain_service_attrs_idx
    ON objects_l15_part2
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_l15_part3_the_geom_domain_service_attrs_idx
    ON objects_l15_part3
    USING gist
    (the_geom, domain_attrs, service_attrs);


CREATE OR REPLACE FUNCTION objects_l_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := vrevisions.get_part(NEW.the_geom);
    IF (NEW.zmin >= 15) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_l15_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l15_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l15_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l15_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 15 ) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_l12_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l12_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l12_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l12_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 9 ) THEN
        INSERT INTO objects_l9 VALUES (NEW.*); 
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_l_insert_trigger() function!'';
    END IF;        
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l9_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin <= 9) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l9 WHERE id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l10_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 10 AND NEW.zmin < 12) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l10 WHERE id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 15 AND NEW.part = OLD.part) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 12 AND zmin < 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l15_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 15 AND NEW.part = OLD.part) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;


CREATE TRIGGER update_objects_l12_part0_trigger
    BEFORE UPDATE
    ON objects_l12_part0
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l12_update_trigger();

CREATE TRIGGER update_objects_l12_part1_trigger
    BEFORE UPDATE
    ON objects_l12_part1
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l12_update_trigger();

CREATE TRIGGER update_objects_l12_part2_trigger
    BEFORE UPDATE
    ON objects_l12_part2
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l12_update_trigger();

CREATE TRIGGER update_objects_l12_part3_trigger
    BEFORE UPDATE
    ON objects_l12_part3
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l12_update_trigger();


CREATE TRIGGER update_objects_l15_part0_trigger
    BEFORE UPDATE
    ON objects_l15_part0
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l15_update_trigger();

CREATE TRIGGER update_objects_l15_part1_trigger
    BEFORE UPDATE
    ON objects_l15_part1
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l15_update_trigger();

CREATE TRIGGER update_objects_l15_part2_trigger
    BEFORE UPDATE
    ON objects_l15_part2
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l15_update_trigger();

CREATE TRIGGER update_objects_l15_part3_trigger
    BEFORE UPDATE
    ON objects_l15_part3
    FOR EACH ROW
    EXECUTE PROCEDURE objects_l15_update_trigger();
');
