SELECT vrevisions.for_vrevisions('
ALTER TABLE objects_p ADD COLUMN part integer;


CREATE TABLE objects_p16_part0 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=0)
)
INHERITS (objects_p);

CREATE TABLE objects_p16_part1 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=1)
)
INHERITS (objects_p);

CREATE TABLE objects_p16_part2 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=2)
)
INHERITS (objects_p);

CREATE TABLE objects_p16_part3 (
    id bigint PRIMARY KEY,
    CHECK (zmin >= 16),
    CHECK (part=3)
)
INHERITS (objects_p);

CREATE INDEX objects_p16_part0_the_geom_domain_service_attrs_idx
    ON objects_p16_part0
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_p16_part1_the_geom_domain_service_attrs_idx
    ON objects_p16_part1
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_p16_part2_the_geom_domain_service_attrs_idx
    ON objects_p16_part2
    USING gist
    (the_geom, domain_attrs, service_attrs);

CREATE INDEX objects_p16_part3_the_geom_domain_service_attrs_idx
    ON objects_p16_part3
    USING gist
    (the_geom, domain_attrs, service_attrs);


CREATE OR REPLACE FUNCTION objects_p_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := vrevisions.get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_p16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_p16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_p16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_p16_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_p_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_p14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_p12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_p10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_p8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7 ) THEN
        INSERT INTO objects_p7 VALUES (NEW.*); 
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_p_insert_trigger() function!'';
    END IF;        
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p_update_trigger()
  RETURNS trigger AS
$BODY$
DECLARE
    table_zmin bigint := TG_ARGV[0];
    table_zmax bigint := TG_ARGV[1];
    table_name text := TG_ARGV[2];
BEGIN
    IF (NEW.zmin >= table_zmin AND NEW.zmin < table_zmax) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    EXECUTE ''DELETE FROM '' || table_name::regclass || '' WHERE id = $1'' USING OLD.id;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16 AND NEW.part = OLD.part) THEN
        NEW.part := vrevisions.get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_p WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;


DROP TRIGGER update_objects_p16_trigger ON objects_p16;
CREATE TRIGGER update_objects_p16_trigger
    BEFORE UPDATE
    ON objects_p16
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p16_update_trigger();

CREATE TRIGGER update_objects_p16_part0_trigger
    BEFORE UPDATE
    ON objects_p16_part0
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p16_update_trigger();

CREATE TRIGGER update_objects_p16_part1_trigger
    BEFORE UPDATE
    ON objects_p16_part1
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p16_update_trigger();

CREATE TRIGGER update_objects_p16_part2_trigger
    BEFORE UPDATE
    ON objects_p16_part2
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p16_update_trigger();

CREATE TRIGGER update_objects_p16_part3_trigger
    BEFORE UPDATE
    ON objects_p16_part3
    FOR EACH ROW
    EXECUTE PROCEDURE objects_p16_update_trigger();
');
