CREATE TABLE service.import_messages (
    id bigserial PRIMARY KEY,
    task_id bigint NOT NULL REFERENCES service.import_task(id),
    description text NOT NULL,
    feature_id bigint
);

COMMENT ON COLUMN service.import_messages.feature_id IS
    'NULL means that description applies to the entire file';

CREATE INDEX import_messages_order_index
    ON service.import_messages USING btree (task_id, id);

CREATE INDEX task_created_idx
    ON service.task USING btree (created);