CREATE TEMP TABLE tmp_reverted_info  AS
SELECT
    id AS reverting_commit_id,
    (regexp_split_to_table(attributes -> '_reverted_commit_ids', ','))::bigint AS reverted_commit_id
FROM revision.commit
WHERE attributes ? '_reverted_commit_ids';

CREATE INDEX ON tmp_reverted_info USING btree (reverting_commit_id);
CREATE INDEX ON tmp_reverted_info USING btree (reverted_commit_id);


UPDATE revision.commit AS c
SET attributes = c.attributes || hstore('_reverting_commit_ids', t.reverting_commit_ids_str)
FROM (
    SELECT
        reverted_commit_id,
        string_agg(reverting_commit_id::text, ',') AS reverting_commit_ids_str
    FROM tmp_reverted_info
    GROUP BY 1) AS t
WHERE c.id = t.reverted_commit_id;
