SET search_path=validation,public;

ALTER TABLE message_attributes ADD COLUMN important_region boolean NOT NULL DEFAULT false;
ALTER TABLE message_attributes ALTER COLUMN important_region DROP DEFAULT;

COMMENT ON COLUMN message_attributes.important_region IS
    'Whether message bb intersects one of the polygons with cat:diffalert_region attribute';

DROP INDEX message_attributes_unique_index;

CREATE UNIQUE INDEX message_attributes_unique_index
    ON message_attributes
    USING btree(severity, check_id, description, important_region);

DROP FUNCTION IF EXISTS insert_message_attributes(
    p_severity integer,
    p_check_id text,
    p_description text);

CREATE OR REPLACE FUNCTION insert_message_attributes(
    p_severity integer,
    p_check_id text,
    p_description text,
    p_important_region boolean)
RETURNS integer AS
$$
DECLARE
    r_attributes_id bigint;
BEGIN
    LOOP
        SELECT attributes_id INTO r_attributes_id
            FROM validation.message_attributes
            WHERE severity=p_severity
                  AND check_id=p_check_id
                  AND description=p_description
                  AND important_region=p_important_region;
        IF FOUND THEN
            RETURN r_attributes_id;
        END IF;

        BEGIN
            INSERT
                INTO validation.message_attributes
                    (severity, check_id, description, important_region)
                VALUES (p_severity, p_check_id, p_description, p_important_region)
                RETURNING attributes_id INTO r_attributes_id;
            RETURN r_attributes_id;
        EXCEPTION WHEN unique_violation THEN
            -- try SELECT again
        END;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

SET search_path=public;