SELECT vrevisions.for_vrevisions('
CREATE OR REPLACE VIEW complex_objects_indirect_highlight_view AS
 SELECT r.master_id,
    s.id,
    s.the_geom,
    s.zmin,
    s.zmax,
    r.domain_attrs,
    r.slave_id,
    s.part
   FROM objects_r r, objects_r r_next, objects_l s
  WHERE r.slave_id = r_next.master_id AND r_next.slave_id = s.id;

CREATE OR REPLACE VIEW complex_objects_l_highlight_view AS
 SELECT r.master_id,
    r.slave_id AS id,
    r.domain_attrs -> ''rel:slave''::text AS slave_category,
    r.domain_attrs -> ''rel:role''::text AS slave_role,
    s.the_geom,
    s.zmin,
    s.zmax,
    s.part
   FROM objects_r r, objects_l s
  WHERE r.slave_id = s.id;

DROP VIEW IF EXISTS complex_objects_highlight_view;
DROP VIEW IF EXISTS complex_objects_p_highlight_view;
DROP VIEW IF EXISTS complex_objects_slaves_view;
DROP VIEW IF EXISTS contour_objects_elements_view;
');

DROP FUNCTION IF EXISTS vrevisions.create_complex_objects_views();
DROP FUNCTION IF EXISTS vrevisions.create_highlight_views();
DROP FUNCTION IF EXISTS vrevisions.create_suggest_views();
