SELECT vrevisions.for_vrevisions('
CREATE OR REPLACE FUNCTION bbox_parts()
  RETURNS geometry[] AS
$BODY$
BEGIN
  RETURN ARRAY[
    ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,4500001), ST_Point(7000000,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
    ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,4500001), ST_Point(2000000,147687969)),3395)];

    --ST_SetSRID(ST_MakeBox2D(ST_Point(2000001,-147687969), ST_Point(7000000,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,4500001), ST_Point(20037483,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-3000000,-147687969), ST_Point(2000000,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-20037483,-147687969), ST_Point(-3000001,7500000)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(-20037483,7500001), ST_Point(-4500001,147687969)),3395),
    --ST_SetSRID(ST_MakeBox2D(ST_Point(7000001,-147687969), ST_Point(20037483,4500000)),3395)
END;
$BODY$
  LANGUAGE plpgsql IMMUTABLE
  COST 1;

CREATE OR REPLACE FUNCTION get_part(the_geom geometry)
  RETURNS integer AS
$BODY$
DECLARE
    geom geometry := ST_SetSRID(the_geom, 3395);
    part integer := 1;
    bbox geometry;
BEGIN
    FOREACH bbox IN ARRAY bbox_parts() LOOP
        IF (geom @ bbox) THEN
            RETURN part;
        END IF;
        part := part + 1;
    END LOOP;
    RETURN 0;
END;
$BODY$
  LANGUAGE plpgsql IMMUTABLE
  COST 1;

CREATE OR REPLACE FUNCTION get_parts(the_geom geometry)
  RETURNS integer[] AS
$BODY$
DECLARE
    geom geometry := ST_SetSRID(the_geom,3395);
    part integer := 0;
    parts integer[] := ARRAY[0];
    bbox geometry;
BEGIN
    FOREACH bbox IN ARRAY bbox_parts() LOOP
        part := part + 1;
        IF (geom && bbox) THEN
            parts := parts || part;
        END IF;
    END LOOP;
    RETURN parts;
END;
$BODY$
  LANGUAGE plpgsql IMMUTABLE
  COST 10;

CREATE OR REPLACE FUNCTION get_parts(
    x1 double precision,
    y1 double precision,
    x2 double precision,
    y2 double precision)
  RETURNS integer[] AS
$BODY$
BEGIN
    RETURN get_parts(ST_MakeBox2D(ST_Point(x1,y1), ST_Point(x2,y2)));
END;
$BODY$
  LANGUAGE plpgsql IMMUTABLE
  COST 10;
');


SELECT vrevisions.for_vrevisions('
CREATE OR REPLACE FUNCTION objects_a10_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 10 AND NEW.zmin < 12) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a10 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 14) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a12 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a14_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 14 AND NEW.zmin < 16) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a14 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16 AND NEW.part = OLD.part) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a7_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin <= 7) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a7 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a8_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 8 AND NEW.zmin < 10) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_a8 WHERE id = OLD.id;
    INSERT INTO objects_a VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_a_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_a16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_a16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_a16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_a16_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_a_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_a14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_a12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_a10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_a8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7 ) THEN
        INSERT INTO objects_a7 VALUES (NEW.*); 
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_a_insert_trigger() function!'';
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l10_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 10 AND NEW.zmin < 12) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l10 WHERE id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l12_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 12 AND NEW.zmin < 15 AND NEW.part = OLD.part) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 12 AND zmin < 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l15_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 15 AND NEW.part = OLD.part) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l WHERE id = OLD.id AND zmin >= 15;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l9_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin <= 9) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_l9 WHERE id = OLD.id;
    INSERT INTO objects_l VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_l_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 15) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_l15_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l15_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l15_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l15_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 15 ) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_l12_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_l12_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_l12_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_l12_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_l_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 9 ) THEN
        INSERT INTO objects_l9 VALUES (NEW.*); 
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_l_insert_trigger() function!'';
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p16_update_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    IF (NEW.zmin >= 16 AND NEW.part = OLD.part) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    DELETE FROM objects_p WHERE id = OLD.id AND zmin >= 16;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p_insert_trigger()
  RETURNS trigger AS
$BODY$
BEGIN
    NEW.part := get_part(NEW.the_geom);
    IF (NEW.zmin >= 16) THEN
        CASE new.part
        WHEN 0 THEN
            INSERT INTO objects_p16_part0 VALUES (NEW.*);
        WHEN 1 THEN
            INSERT INTO objects_p16_part1 VALUES (NEW.*);
        WHEN 2 THEN
            INSERT INTO objects_p16_part2 VALUES (NEW.*);
        WHEN 3 THEN
            INSERT INTO objects_p16_part3 VALUES (NEW.*);
        ELSE
            RAISE EXCEPTION ''Invalid part. Fix the objects_p_insert_trigger() function!'';
        END CASE;
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_p14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_p12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_p10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_p8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7 ) THEN
        INSERT INTO objects_p7 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION ''Zoom out of range.  Fix the objects_p_insert_trigger() function!'';
    END IF;
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION objects_p_update_trigger()
  RETURNS trigger AS
$BODY$
DECLARE
    table_zmin bigint := TG_ARGV[0];
    table_zmax bigint := TG_ARGV[1];
    table_name text := TG_ARGV[2];
BEGIN
    IF (NEW.zmin >= table_zmin AND NEW.zmin < table_zmax) THEN
        NEW.part := get_part(NEW.the_geom);
        RETURN NEW;
    END IF;
    EXECUTE ''DELETE FROM '' || table_name::regclass || '' WHERE id = $1'' USING OLD.id;
    INSERT INTO objects_p VALUES (NEW.*);
    RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql;
');

DROP FUNCTION IF EXISTS vrevisions.get_parts(double precision, double precision, double precision, double precision);
DROP FUNCTION IF EXISTS vrevisions.get_part(geometry);
DROP FUNCTION IF EXISTS vrevisions.bbox_parts();
