CREATE TYPE service.merge_action_type AS ENUM (
    'replace',
    'combine'
);

CREATE TABLE service.merge_task (
    id bigint PRIMARY KEY REFERENCES service.task (id),
    action service.merge_action_type NOT NULL,
    source text NOT NULL,
    layers text[] NOT NULL,
    aoi_geom geometry NOT NULL,
    merge_region_ids bigint[] NOT NULL,
    lock_id bigint NOT NULL,
    source_head_commit_id bigint NOT NULL
);

CREATE TABLE service.merge_commit (
   task_id bigint NOT NULL REFERENCES service.merge_task(id),
   commit_id bigint NOT NULL,
   synchronized boolean NOT NULL DEFAULT false,

   PRIMARY KEY (task_id, commit_id)
);
