CREATE TYPE social.feedback_task_resolution AS ENUM (
    'rejected',
    'accepted'
);

CREATE TABLE social.feedback_task(
    id bigserial PRIMARY KEY,
    created_at timestamp with time zone NOT NULL DEFAULT now(),

    position geometry(GEOMETRY, 3395) NOT NULL,
    type text NOT NULL,
    description text NOT NULL,
    attrs json NOT NULL DEFAULT '{}'::json,

    acquired_by bigint,
    acquired_at timestamp with time zone,

    resolved_by bigint,
    resolved_at timestamp with time zone,
    resolution social.feedback_task_resolution,

    closed_by bigint,
    closed_at timestamp with time zone
);

CREATE INDEX feedback_task_position_idx ON social.feedback_task USING gist(position);
CREATE INDEX feedback_task_acquired_by_idx ON social.feedback_task USING btree(acquired_by);


CREATE TABLE social.commit_feedback_task(
    commit_id bigint REFERENCES revision.commit(id),
    feedback_task_id bigint REFERENCES social.feedback_task(id)
);

CREATE TABLE social.star_trek_issue(
    id bigserial PRIMARY KEY,
    created_at timestamp with time zone NOT NULL DEFAULT now(),
    star_trek_key text NOT NULL,
    feedback_task_id bigint REFERENCES social.feedback_task(id),
    attrs json
);


